/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.monitor.core.instrument.cumulative;

import com.tongweb.commons.monitor.core.instrument.AbstractTimer;
import com.tongweb.commons.monitor.core.instrument.Clock;
import com.tongweb.commons.monitor.core.instrument.Meter;
import com.tongweb.commons.monitor.core.instrument.distribution.DistributionStatisticConfig;
import com.tongweb.commons.monitor.core.instrument.distribution.TimeWindowMax;
import com.tongweb.commons.monitor.core.instrument.distribution.pause.PauseDetector;
import com.tongweb.commons.monitor.core.instrument.util.TimeUtils;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class CumulativeTimer
extends AbstractTimer {
    private final AtomicLong count = new AtomicLong();
    private final AtomicLong total = new AtomicLong();
    private final TimeWindowMax max;

    public CumulativeTimer(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector, TimeUnit baseTimeUnit) {
        this(id, clock, distributionStatisticConfig, pauseDetector, baseTimeUnit, false);
    }

    public CumulativeTimer(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector, TimeUnit baseTimeUnit, boolean supportsAggregablePercentiles) {
        super(id, clock, distributionStatisticConfig, pauseDetector, baseTimeUnit, supportsAggregablePercentiles);
        this.max = new TimeWindowMax(clock, distributionStatisticConfig);
    }

    @Override
    protected void recordNonNegative(long amount, TimeUnit unit) {
        long nanoAmount = (long)TimeUtils.convert(amount, unit, TimeUnit.NANOSECONDS);
        this.count.getAndAdd(1L);
        this.total.getAndAdd(nanoAmount);
        this.max.record(nanoAmount, TimeUnit.NANOSECONDS);
    }

    @Override
    public long count() {
        return this.count.get();
    }

    @Override
    public double totalTime(TimeUnit unit) {
        return TimeUtils.nanosToUnit(this.total.get(), unit);
    }

    @Override
    public double max(TimeUnit unit) {
        return this.max.poll(unit);
    }
}

