/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.springboot.starter;

import com.tongtech.commons.license.LicenseSDKProvider;
import com.tongtech.commons.license.utils.EnvConfigEnum;
import com.tongtech.commons.utils.ClashPreventUtils;
import com.tongtech.commons.utils.SystemExitUtil;
import com.tongweb.commons.util.WebServerFactoryUtils;
import com.tongweb.connector.AbstractProtocol;
import com.tongweb.connector.ProtocolHandler;
import com.tongweb.connector.UpgradeProtocol;
import com.tongweb.connector.http2.Http2Protocol;
import com.tongweb.container.Container;
import com.tongweb.container.Context;
import com.tongweb.container.Engine;
import com.tongweb.container.Host;
import com.tongweb.container.LifecycleEvent;
import com.tongweb.container.LifecycleException;
import com.tongweb.container.LifecycleListener;
import com.tongweb.container.Loader;
import com.tongweb.container.Manager;
import com.tongweb.container.Valve;
import com.tongweb.container.WebResource;
import com.tongweb.container.WebResourceRoot;
import com.tongweb.container.WebResourceSet;
import com.tongweb.container.Wrapper;
import com.tongweb.container.connector.Connector;
import com.tongweb.container.core.AprLifecycleListener;
import com.tongweb.container.core.StandardContext;
import com.tongweb.container.loader.WebappLoader;
import com.tongweb.container.session.StandardManager;
import com.tongweb.container.startup.ServletContainer;
import com.tongweb.container.util.LifecycleBase;
import com.tongweb.container.util.ServerInfo;
import com.tongweb.container.valves.ManageFilterValve;
import com.tongweb.container.valves.RemoteAddrValve;
import com.tongweb.container.valves.RemoteHostValve;
import com.tongweb.container.webresources.AbstractResourceSet;
import com.tongweb.container.webresources.EmptyResource;
import com.tongweb.container.webresources.StandardRoot;
import com.tongweb.juli.logging.Log;
import com.tongweb.juli.logging.LogFactory;
import com.tongweb.springboot.properties.IoMode;
import com.tongweb.springboot.properties.ManageWebProperties;
import com.tongweb.springboot.properties.PropertyMapper;
import com.tongweb.springboot.properties.RemoteFilterConfigBean;
import com.tongweb.springboot.properties.TongWebProperties;
import com.tongweb.springboot.properties.TongwebConfig;
import com.tongweb.springboot.starter.CheckIntegrityUtil;
import com.tongweb.springboot.starter.CompressionConnectorCustomizer;
import com.tongweb.springboot.starter.ConfigurableTongWebServerFactory;
import com.tongweb.springboot.starter.DisableReferenceClearingContextCustomizer;
import com.tongweb.springboot.starter.SslConnectorCustomizer;
import com.tongweb.springboot.starter.TldSkipPatterns;
import com.tongweb.springboot.starter.TongWebConnectorCustomizer;
import com.tongweb.springboot.starter.TongWebContextCustomizer;
import com.tongweb.springboot.starter.TongWebEmbedContext;
import com.tongweb.springboot.starter.TongWebEmbedWebappClassLoader;
import com.tongweb.springboot.starter.TongWebErrorPage;
import com.tongweb.springboot.starter.TongWebProtocolHandlerCustomizer;
import com.tongweb.springboot.starter.TongWebServer;
import com.tongweb.springboot.starter.TongWebStarter;
import com.tongweb.web.JarScanFilter;
import com.tongweb.web.util.descriptor.web.SecurityCollection;
import com.tongweb.web.util.descriptor.web.SecurityConstraint;
import com.tongweb.web.util.modeler.Registry;
import com.tongweb.web.util.scan.StandardJarScanFilter;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.CodeSource;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContainerInitializer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.util.LambdaSafe;
import org.springframework.boot.web.server.ErrorPage;
import org.springframework.boot.web.server.MimeMappings;
import org.springframework.boot.web.server.WebServer;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.boot.web.servlet.server.AbstractServletWebServerFactory;
import org.springframework.boot.web.servlet.server.Jsp;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class TongWebServletWebServerFactory
extends AbstractServletWebServerFactory
implements ConfigurableTongWebServerFactory,
ResourceLoaderAware {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final Log log = LogFactory.getLog(TongWebServletWebServerFactory.class);
    private static final Set<Class<?>> NO_CLASSES = Collections.emptySet();
    @Autowired
    private TongWebProperties tongWebProperties;
    @Value(value="${management.endpoints.web.base-path:}")
    private String contextPath;
    @Autowired
    private ManageWebProperties manageWebProperties;
    @Autowired
    private ApplicationContext context;
    public static final String DEFAULT_PROTOCOL = "com.tongweb.connector.http11.Http11NioProtocol";
    private File baseDirectory;
    private List<Valve> engineValves = new ArrayList<Valve>();
    private Valve accessLog;
    private Valve semaphore;
    private RemoteFilterConfigBean remoteFilter;
    private List<Valve> contextValves = new ArrayList<Valve>();
    private List<LifecycleListener> contextLifecycleListeners = new ArrayList<LifecycleListener>();
    private Set<TongWebContextCustomizer> tongWebContextCustomizers = new LinkedHashSet<TongWebContextCustomizer>();
    private Set<TongWebConnectorCustomizer> tongWebConnectorCustomizers = new LinkedHashSet<TongWebConnectorCustomizer>();
    private Set<TongWebProtocolHandlerCustomizer<?>> tongWebProtocolHandlerCustomizers = new LinkedHashSet();
    private final List<Connector> additionalTongWebConnectors = new ArrayList<Connector>();
    private ResourceLoader resourceLoader;
    private String protocol = "com.tongweb.connector.http11.Http11NioProtocol";
    private Set<String> tldSkipPatterns = new LinkedHashSet<String>(TldSkipPatterns.DEFAULT);
    private Charset uriEncoding = DEFAULT_CHARSET;
    private int backgroundProcessorDelay;
    private boolean disableMBeanRegistry = true;
    private List<String> notAllowHttpMethods = new ArrayList<String>();
    private Boolean enableLookups = false;
    private Map<String, String> webApps;
    private String war;
    private Jsp jsp = new Jsp();

    public Boolean getEnableLookups() {
        return this.enableLookups;
    }

    public void setEnableLookups(Boolean enableLookups) {
        this.enableLookups = enableLookups;
    }

    public TongWebServletWebServerFactory() {
    }

    @PostConstruct
    private void init() {
        this.initDisableMBeanRegistry();
    }

    private static List<LifecycleListener> getDefaultLifecycleListeners() {
        AprLifecycleListener aprLifecycleListener = new AprLifecycleListener();
        return AprLifecycleListener.isAprAvailable() ? new ArrayList<AprLifecycleListener>(Collections.singletonList(aprLifecycleListener)) : new ArrayList();
    }

    public List<String> getNotAllowHttpMethods() {
        return this.notAllowHttpMethods;
    }

    public void setNotAllowHttpMethods(List<String> notAllowHttpMethods) {
        this.notAllowHttpMethods = notAllowHttpMethods;
    }

    public boolean isDisableMBeanRegistry() {
        return this.disableMBeanRegistry;
    }

    public void setDisableMBeanRegistry(boolean disableMBeanRegistry) {
        this.disableMBeanRegistry = disableMBeanRegistry;
    }

    public TongWebServletWebServerFactory(int port) {
        super(port);
    }

    public TongWebServletWebServerFactory(String contextPath, int port) {
        super(contextPath, port);
    }

    public WebServer getWebServer(ServletContextInitializer ... initializers) {
        System.setProperty("java.security.egd", "file:/dev/./urandom");
        this.addExitHook();
        this.processLicenseValidateConfig();
        if (this.tongWebProperties.getTongweb().getCheckClassConflict().booleanValue()) {
            try {
                ClashPreventUtils.check();
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage());
            }
        }
        if (!ObjectUtils.isEmpty(this.tongWebProperties.getTongweb().getAdditionalTldSkipPatterns())) {
            this.getTldSkipPatterns().addAll(this.tongWebProperties.getTongweb().getAdditionalTldSkipPatterns());
        }
        if (this.disableMBeanRegistry) {
            Registry.disableRegistry();
        }
        ServletContainer servletContainer = new ServletContainer();
        File baseDir = this.baseDirectory != null ? this.baseDirectory : this.createTempDir("tongweb");
        servletContainer.setBaseDir(baseDir.getAbsolutePath());
        if (this.protocol.equalsIgnoreCase(IoMode.APR.getClassName())) {
            AprLifecycleListener arpLifecycle = new AprLifecycleListener();
            this.addContextLifecycleListeners(new LifecycleListener[]{arpLifecycle});
        }
        Connector connector = new Connector(this.protocol);
        servletContainer.getService().addConnector(connector);
        this.customizeConnector(connector);
        servletContainer.setConnector(connector);
        servletContainer.getHost().setAutoDeploy(false);
        this.configureEngine(servletContainer.getEngine());
        this.configureAccessLog(servletContainer.getHost());
        this.configureSemaphore(servletContainer.getHost());
        this.configureFilterValue(servletContainer.getHost());
        this.configureRemoteFilter(servletContainer.getHost());
        for (Connector additionalConnector : this.additionalTongWebConnectors) {
            servletContainer.getService().addConnector(additionalConnector);
        }
        this.prepareContext(servletContainer.getHost(), initializers);
        this.configureWebApps(servletContainer);
        this.configureWar(servletContainer);
        this.configNaming(servletContainer);
        return this.getTongWebServer(servletContainer);
    }

    public void setWebApps(Map<String, String> webApps) {
        this.webApps = webApps;
    }

    public void setWar(String war) {
        this.war = war;
    }

    public void configureWebApps(ServletContainer servletContainer) {
        if (this.webApps != null) {
            this.webApps.forEach((key, value) -> {
                new File(servletContainer.getServer().getCatalinaBase(), "webapps").mkdirs();
                StandardContext context = (StandardContext)servletContainer.addWebapp(key.startsWith("/") ? key : "/" + key, value);
                context.setParentClassLoader(this.resourceLoader != null ? this.resourceLoader.getClassLoader() : ClassUtils.getDefaultClassLoader());
                WebappLoader loader = new WebappLoader();
                loader.setLoaderClass(TongWebEmbedWebappClassLoader.class.getName());
                if (StringUtils.hasText((String)this.tongWebProperties.getTongweb().getResourceCacheList())) {
                    loader.setCacheResourceNames(this.tongWebProperties.getTongweb().getResourceCacheList());
                }
                loader.setDelegate(true);
                context.setLoader((Loader)loader);
                context.addLifecycleListener((LifecycleListener)new StaticResourceConfigurer((Context)context));
                context.setReloadable(false);
                this.resetDefaultLocaleMapping((Context)context);
                this.addLocaleMappings((Context)context);
                try {
                    if (this.tongWebProperties.getTongweb().getUseRelativeRedirects() != null) {
                        context.setUseRelativeRedirects(this.tongWebProperties.getTongweb().getUseRelativeRedirects().booleanValue());
                    }
                    if (this.tongWebProperties.getTongweb().getRedirectWhenLocation() != null) {
                        context.setRedirectWhenLocation(this.tongWebProperties.getTongweb().getRedirectWhenLocation().booleanValue());
                    }
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                this.configureTldSkipPatterns((Context)context);
                if (this.shouldRegisterJspServlet()) {
                    this.addJspServlet((Context)context);
                    try {
                        ServletContainerInitializer initializer = (ServletContainerInitializer)ClassUtils.forName((String)"com.tongweb.jasper.servlet.JasperInitializer", null).newInstance();
                        context.addServletContainerInitializer(initializer, null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.configurePluggSkipPatterns((Context)context);
                for (LifecycleListener lifecycleListener : this.contextLifecycleListeners) {
                    context.addLifecycleListener(lifecycleListener);
                }
                for (Valve valve : this.contextValves) {
                    context.getPipeline().addValve(valve);
                }
                for (ErrorPage errorPage : this.getErrorPages()) {
                    new TongWebErrorPage(errorPage).addToContext((Context)context);
                }
                for (MimeMappings.Mapping mapping : this.getMimeMappings()) {
                    context.addMimeMapping(mapping.getExtension(), mapping.getMimeType());
                }
                this.configureSession((Context)context);
                this.configureResources((Context)context);
                new DisableReferenceClearingContextCustomizer().customize((Context)context);
                for (TongWebContextCustomizer customizer : this.tongWebContextCustomizers) {
                    customizer.customize((Context)context);
                }
            });
        }
    }

    public void configureWar(ServletContainer servletContainer) {
        if (this.war != null && this.war.length() != 0) {
            new File(servletContainer.getServer().getCatalinaBase(), "webapps").mkdirs();
            StandardContext context = (StandardContext)servletContainer.addWebapp("", this.war);
            context.setParentClassLoader(this.resourceLoader != null ? this.resourceLoader.getClassLoader() : ClassUtils.getDefaultClassLoader());
            WebappLoader loader = new WebappLoader();
            loader.setLoaderClass(TongWebEmbedWebappClassLoader.class.getName());
            if (StringUtils.hasText((String)this.tongWebProperties.getTongweb().getResourceCacheList())) {
                loader.setCacheResourceNames(this.tongWebProperties.getTongweb().getResourceCacheList());
            }
            loader.setDelegate(true);
            context.setLoader((Loader)loader);
            context.addLifecycleListener((LifecycleListener)new StaticResourceConfigurer((Context)context));
            context.setReloadable(false);
            this.resetDefaultLocaleMapping((Context)context);
            this.addLocaleMappings((Context)context);
            try {
                if (this.tongWebProperties.getTongweb().getUseRelativeRedirects() != null) {
                    context.setUseRelativeRedirects(this.tongWebProperties.getTongweb().getUseRelativeRedirects().booleanValue());
                }
                if (this.tongWebProperties.getTongweb().getRedirectWhenLocation() != null) {
                    context.setRedirectWhenLocation(this.tongWebProperties.getTongweb().getRedirectWhenLocation().booleanValue());
                }
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            this.configurePluggSkipPatterns((Context)context);
            this.configureTldSkipPatterns((Context)context);
            if (this.shouldRegisterJspServlet()) {
                this.addJspServlet((Context)context);
                try {
                    ServletContainerInitializer initializer = (ServletContainerInitializer)ClassUtils.forName((String)"com.tongweb.jasper.servlet.JasperInitializer", null).newInstance();
                    context.addServletContainerInitializer(initializer, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (LifecycleListener lifecycleListener : this.contextLifecycleListeners) {
                context.addLifecycleListener(lifecycleListener);
            }
            for (Valve valve : this.contextValves) {
                context.getPipeline().addValve(valve);
            }
            for (ErrorPage errorPage : this.getErrorPages()) {
                new TongWebErrorPage(errorPage).addToContext((Context)context);
            }
            for (MimeMappings.Mapping mapping : this.getMimeMappings()) {
                context.addMimeMapping(mapping.getExtension(), mapping.getMimeType());
            }
            this.configureSession((Context)context);
            this.configureResources((Context)context);
            new DisableReferenceClearingContextCustomizer().customize((Context)context);
            for (TongWebContextCustomizer customizer : this.tongWebContextCustomizers) {
                customizer.customize((Context)context);
            }
        }
    }

    private void configNaming(ServletContainer servletContainer) {
        if (this.tongWebProperties.getTongweb().getNamingEnabled().booleanValue()) {
            servletContainer.enableNaming();
        }
    }

    private void addExitHook() {
        SystemExitUtil.setHook(() -> System.exit(SpringApplication.exit((ApplicationContext)this.context, (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> 0})));
    }

    private void processLicenseValidateConfig() {
        ServerInfo.getServerENumber();
        new CheckIntegrityUtil();
        PropertyMapper propertyMapper = PropertyMapper.get();
        propertyMapper.from(this.tongWebProperties.getTongweb()).whenNonNull().as(TongwebConfig::getLicense).whenNonNull().to(license -> {
            propertyMapper.from(license.getType().getValidateType()).to(arg_0 -> ((EnvConfigEnum)EnvConfigEnum.LICENSE_LICENSE_TYPE).setSystemProperty(arg_0));
            propertyMapper.from(license.getLicenseIps()).to(arg_0 -> ((EnvConfigEnum)EnvConfigEnum.LICENSE_IPS).setSystemProperty(arg_0));
            propertyMapper.from(license.getLicensePublicKey()).to(arg_0 -> ((EnvConfigEnum)EnvConfigEnum.LICENSE_PUBLIC_KEY).setSystemProperty(arg_0));
            propertyMapper.from(license.getPath()).to(arg_0 -> ((EnvConfigEnum)EnvConfigEnum.LICENSE_FILE_PATH).setSystemProperty(arg_0));
            propertyMapper.from(license.isSync()).to(arg_0 -> ((EnvConfigEnum)EnvConfigEnum.LICENSE_IS_SYNC).setSystemProperty(arg_0));
            propertyMapper.from(license.isSslEnabled()).to(arg_0 -> ((EnvConfigEnum)EnvConfigEnum.LICENSE_SSL_ENABLED).setSystemProperty(arg_0));
            propertyMapper.from(license.getSsl()).whenNonNull().to(ssl -> {
                propertyMapper.from(ssl.getKeyStore()).to(arg_0 -> ((EnvConfigEnum)EnvConfigEnum.LICENSE_SSL_KEY_STORE).setSystemProperty(arg_0));
                propertyMapper.from(ssl.getKeyStorePassword()).to(arg_0 -> ((EnvConfigEnum)EnvConfigEnum.LICENSE_SSL_KEY_STORE_PASSWORD).setSystemProperty(arg_0));
                propertyMapper.from(ssl.getKeyStoreType()).to(arg_0 -> ((EnvConfigEnum)EnvConfigEnum.LICENSE_SSL_KEY_STORE_TYPE).setSystemProperty(arg_0));
                propertyMapper.from(ssl.getTrustStore()).to(arg_0 -> ((EnvConfigEnum)EnvConfigEnum.LICENSE_SSL_TRUST_STORE).setSystemProperty(arg_0));
                propertyMapper.from(ssl.getTrustStorePassword()).to(arg_0 -> ((EnvConfigEnum)EnvConfigEnum.LICENSE_SSL_TRUST_STORE_PASSWORD).setSystemProperty(arg_0));
                propertyMapper.from(ssl.getTrustStoreType()).to(arg_0 -> ((EnvConfigEnum)EnvConfigEnum.LICENSE_SSL_TRUST_STORE_TYPE).setSystemProperty(arg_0));
            });
        });
        LicenseSDKProvider.validate();
    }

    private void configureAccessLog(Host host) {
        if (this.getAccessLog() != null) {
            host.getPipeline().addValve(this.getAccessLog());
        }
    }

    private void configureSemaphore(Host host) {
        if (this.getSemaphore() != null) {
            host.getPipeline().addValve(this.getSemaphore());
        }
    }

    private void configureFilterValue(Host host) {
        if (StringUtils.hasText((String)this.contextPath) && (StringUtils.hasText((String)this.manageWebProperties.getAccessIpList()) || StringUtils.hasText((String)this.manageWebProperties.getBlockedIpList()))) {
            ManageFilterValve filterValve = new ManageFilterValve();
            filterValve.setAccessIpList(this.manageWebProperties.getAccessIpList());
            filterValve.setBlockedIpList(this.manageWebProperties.getBlockedIpList());
            filterValve.setManageContextPath(this.contextPath);
            host.getPipeline().addValve((Valve)filterValve);
        }
    }

    public void configureRemoteFilter(Host host) {
        RemoteFilterConfigBean filter = this.getRemoteFilter();
        if (filter == null) {
            return;
        }
        String allowAddr = filter.getAllowAddr();
        String allowHost = filter.getAllowHost();
        String denyAddr = filter.getDenyAddr();
        String denyHost = filter.getDenyHost();
        Integer status = filter.getDenyStatus();
        Valve[] valves = host.getPipeline().getValves();
        for (int i = 0; valves != null && i < valves.length; ++i) {
            if (valves[i] instanceof RemoteAddrValve) {
                host.getPipeline().removeValve(valves[i]);
            }
            if (!(valves[i] instanceof RemoteHostValve)) continue;
            host.getPipeline().removeValve(valves[i]);
        }
        if (allowAddr != null || denyAddr != null) {
            RemoteAddrValve remoteAddrValve = new RemoteAddrValve();
            remoteAddrValve.setDenyStatus(status.intValue());
            if (allowAddr != null) {
                if (allowAddr.equals("*")) {
                    allowAddr = ".*";
                }
                remoteAddrValve.setAllow(allowAddr);
            }
            if (denyAddr != null) {
                if (denyAddr.equals("*")) {
                    denyAddr = ".*";
                }
                remoteAddrValve.setDeny(denyAddr);
            }
            if (remoteAddrValve != null) {
                host.getPipeline().addValve((Valve)remoteAddrValve);
            }
        }
        if (!(allowHost == null & denyHost == null)) {
            RemoteHostValve remoteHostValve = new RemoteHostValve();
            remoteHostValve.setDenyStatus(status.intValue());
            if (allowHost != null) {
                if (allowHost.equals("*")) {
                    allowHost = ".*";
                }
                remoteHostValve.setAllow(allowHost);
            }
            if (denyHost != null) {
                if (denyHost.equals("*")) {
                    denyHost = ".*";
                }
                remoteHostValve.setDeny(denyHost);
            }
            if (remoteHostValve != null) {
                host.getPipeline().addValve((Valve)remoteHostValve);
            }
        }
    }

    private void configureEngine(Engine engine) {
        engine.setBackgroundProcessorDelay(this.backgroundProcessorDelay);
        for (Valve valve : this.engineValves) {
            engine.getPipeline().addValve(valve);
        }
        engine.addLifecycleListener(event -> {
            if ("before_stop".equals(event.getType())) {
                LicenseSDKProvider.exit();
            }
        });
    }

    protected void prepareContext(Host host, ServletContextInitializer[] initializers) {
        File documentRoot = this.getValidDocumentRoot();
        TongWebEmbedContext context = new TongWebEmbedContext();
        if (documentRoot != null) {
            context.setResources((WebResourceRoot)new LoaderHidingResourceRoot(context));
        }
        context.setName(this.getContextPath());
        context.setDisplayName(this.getDisplayName());
        context.setPath(this.getContextPath());
        File docBase = documentRoot != null ? documentRoot : this.createTempDir("tongweb-docbase");
        context.setDocBase(docBase.getAbsolutePath());
        context.addLifecycleListener((LifecycleListener)new ServletContainer.FixContextListener());
        context.setParentClassLoader(this.resourceLoader != null ? this.resourceLoader.getClassLoader() : ClassUtils.getDefaultClassLoader());
        this.resetDefaultLocaleMapping((Context)context);
        this.addLocaleMappings((Context)context);
        try {
            context.setCreateUploadTargets(true);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        if (this.tongWebProperties.getTongweb().getUseRelativeRedirects() != null) {
            context.setUseRelativeRedirects(this.tongWebProperties.getTongweb().getUseRelativeRedirects());
        }
        if (this.tongWebProperties.getTongweb().getRedirectWhenLocation() != null) {
            context.setRedirectWhenLocation(this.tongWebProperties.getTongweb().getRedirectWhenLocation());
        }
        this.configureTldSkipPatterns((Context)context);
        WebappLoader loader = new WebappLoader(context.getParentClassLoader());
        loader.setLoaderClass(TongWebEmbedWebappClassLoader.class.getName());
        loader.setDelegate(true);
        context.setLoader((Loader)loader);
        if (this.isRegisterDefaultServlet()) {
            this.addDefaultServlet((Context)context);
        }
        if (this.shouldRegisterJspServlet()) {
            this.addJspServlet((Context)context);
            this.addJasperInitializer(context);
        }
        context.addLifecycleListener(new StaticResourceConfigurer((Context)context));
        context.setReloadable(false);
        ServletContextInitializer[] initializersToUse = this.mergeInitializers(initializers);
        host.addChild((Container)context);
        this.configureContext((Context)context, initializersToUse);
        this.postProcessContext((Context)context);
    }

    public Jsp getJsp() {
        return this.jsp;
    }

    public void setJsp(Jsp jsp) {
        this.jsp = jsp;
    }

    protected boolean shouldRegisterJspServlet() {
        this.jsp.setClassName("com.tongweb.jasper.servlet.JspServlet");
        return this.jsp != null && this.jsp.getRegistered() && ClassUtils.isPresent((String)this.jsp.getClassName(), (ClassLoader)this.getClass().getClassLoader());
    }

    private void resetDefaultLocaleMapping(Context context) {
        context.addLocaleEncodingMappingParameter(Locale.ENGLISH.toString(), DEFAULT_CHARSET.displayName());
        context.addLocaleEncodingMappingParameter(Locale.FRENCH.toString(), DEFAULT_CHARSET.displayName());
    }

    private void addLocaleMappings(Context context) {
        for (Map.Entry entry : this.getLocaleCharsetMappings().entrySet()) {
            Locale locale = (Locale)entry.getKey();
            Charset charset = (Charset)entry.getValue();
            context.addLocaleEncodingMappingParameter(locale.toString(), charset.toString());
        }
    }

    private void configureTldSkipPatterns(Context context) {
        StandardJarScanFilter filter = new StandardJarScanFilter();
        filter.setTldSkip(StringUtils.collectionToCommaDelimitedString(this.tldSkipPatterns));
        context.getJarScanner().setJarScanFilter((JarScanFilter)filter);
    }

    private void configurePluggSkipPatterns(Context context) {
    }

    private void addDefaultServlet(Context context) {
        Wrapper defaultServlet = context.createWrapper();
        defaultServlet.setName("default");
        defaultServlet.setServletClass("com.tongweb.container.servlets.DefaultServlet");
        defaultServlet.addInitParameter("debug", "0");
        defaultServlet.addInitParameter("listings", "false");
        defaultServlet.setLoadOnStartup(1);
        defaultServlet.setOverridable(true);
        context.addChild((Container)defaultServlet);
        context.addServletMappingDecoded("/", "default");
    }

    private void addJspServlet(Context context) {
        Wrapper jspServlet = context.createWrapper();
        jspServlet.setName("jsp");
        jspServlet.setServletClass(this.getJsp().getClassName());
        jspServlet.addInitParameter("fork", "false");
        for (Map.Entry initParameter : this.getJsp().getInitParameters().entrySet()) {
            jspServlet.addInitParameter((String)initParameter.getKey(), (String)initParameter.getValue());
        }
        jspServlet.setLoadOnStartup(3);
        context.addChild((Container)jspServlet);
        context.addServletMappingDecoded("*.jsp", "jsp");
        context.addServletMappingDecoded("*.jspx", "jsp");
    }

    private void addJasperInitializer(TongWebEmbedContext context) {
        try {
            ServletContainerInitializer initializer = (ServletContainerInitializer)ClassUtils.forName((String)"com.tongweb.jasper.servlet.JasperInitializer", null).newInstance();
            context.addServletContainerInitializer(initializer, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void customizeConnector(Connector connector) {
        if (this.notAllowHttpMethods.contains("TRACE") || this.notAllowHttpMethods.contains("trace") || !this.tongWebProperties.getTongweb().getAllowTrace().booleanValue()) {
            connector.setAllowTrace(false);
        } else {
            connector.setAllowTrace(true);
        }
        int port = this.getPort() >= 0 ? this.getPort() : 0;
        connector.setPort(port);
        if (StringUtils.hasText((String)this.getServerHeader())) {
            connector.setAttribute("server", (Object)this.getServerHeader());
        }
        if (connector.getProtocolHandler() instanceof AbstractProtocol) {
            this.customizeProtocol((AbstractProtocol)connector.getProtocolHandler());
        }
        this.invokeProtocolHandlerCustomizers(connector.getProtocolHandler());
        if (this.getUriEncoding() != null) {
            connector.setURIEncoding(this.getUriEncoding().name());
        }
        connector.setProperty("bindOnInit", "false");
        if (this.getSsl() != null && this.getSsl().isEnabled()) {
            this.customizeSsl(connector);
        }
        CompressionConnectorCustomizer compression = new CompressionConnectorCustomizer(this.tongWebProperties);
        compression.customize(connector);
        for (TongWebConnectorCustomizer customizer : this.tongWebConnectorCustomizers) {
            customizer.customize(connector);
        }
    }

    private void customizeProtocol(AbstractProtocol<?> protocol) {
        if (this.getAddress() != null) {
            protocol.setAddress(this.getAddress());
        }
    }

    private void invokeProtocolHandlerCustomizers(ProtocolHandler protocolHandler) {
        LambdaSafe.callbacks(TongWebProtocolHandlerCustomizer.class, this.tongWebProtocolHandlerCustomizers, (Object)protocolHandler, (Object[])new Object[0]).invoke(customizer -> customizer.customize(protocolHandler));
    }

    private void customizeSsl(Connector connector) {
        new SslConnectorCustomizer(this.getSsl(), this.getSslStoreProvider()).customize(connector);
        if (this.getHttp2() != null && this.getHttp2().isEnabled()) {
            connector.addUpgradeProtocol((UpgradeProtocol)new Http2Protocol());
        }
    }

    protected void configureContext(Context context, ServletContextInitializer[] initializers) {
        TongWebStarter starter = new TongWebStarter(initializers);
        if (context instanceof TongWebEmbedContext) {
            ((TongWebEmbedContext)context).setStarter(starter);
        }
        context.addServletContainerInitializer((ServletContainerInitializer)starter, NO_CLASSES);
        for (LifecycleListener lifecycleListener : this.contextLifecycleListeners) {
            context.addLifecycleListener(lifecycleListener);
        }
        new WebServerFactoryUtils(this, webListenerClassNames -> {
            for (String webListenerClassName : webListenerClassNames) {
                context.addApplicationListener(webListenerClassName);
            }
        }).done();
        for (Valve valve : this.contextValves) {
            context.getPipeline().addValve(valve);
        }
        for (ErrorPage errorPage : this.getErrorPages()) {
            new TongWebErrorPage(errorPage).addToContext(context);
        }
        for (MimeMappings.Mapping mapping : this.getMimeMappings()) {
            context.addMimeMapping(mapping.getExtension(), mapping.getMimeType());
        }
        this.configureSession(context);
        this.configureResources(context);
        new DisableReferenceClearingContextCustomizer().customize(context);
        for (TongWebContextCustomizer customizer : this.tongWebContextCustomizers) {
            customizer.customize(context);
        }
    }

    private void configureResources(Context context) {
        WebResourceRoot resourceRoot = context.getResources();
        if (Objects.isNull(resourceRoot)) {
            resourceRoot = new StandardRoot(context);
        }
        resourceRoot.setCachingAllowed(this.tongWebProperties.getTongweb().getResource().isAllowCaching());
        resourceRoot.setCacheObjectMaxSize(this.tongWebProperties.getTongweb().getResource().getCacheObjectMaxSize().intValue());
        resourceRoot.setCacheMaxSize(this.tongWebProperties.getTongweb().getResource().getCacheMaxSize().longValue());
        resourceRoot.setCacheTtl(this.tongWebProperties.getTongweb().getResource().getCacheTtl());
        context.setResources(resourceRoot);
    }

    private void configureSession(Context context) {
        long sessionTimeout = this.getSessionTimeoutInMinutes();
        context.setSessionTimeout((int)sessionTimeout);
        if (this.getSession().isPersistent()) {
            Manager manager = context.getManager();
            if (manager == null) {
                manager = new StandardManager();
                context.setManager(manager);
            }
            this.configurePersistSession(manager);
        } else {
            context.addLifecycleListener((LifecycleListener)new DisablePersistSessionListener());
        }
    }

    private void configurePersistSession(Manager manager) {
        Assert.state((boolean)(manager instanceof StandardManager), () -> "Unable to persist HTTP session state using manager type " + manager.getClass().getName());
        File dir = this.getValidSessionStoreDir();
        File file = new File(dir, "SESSIONS.ser");
        ((StandardManager)manager).setPathname(file.getAbsolutePath());
    }

    private long getSessionTimeoutInMinutes() {
        Duration sessionTimeout = this.getSession().getTimeout();
        if (this.isZeroOrLess(sessionTimeout)) {
            return 0L;
        }
        return Math.max(sessionTimeout.toMinutes(), 1L);
    }

    private boolean isZeroOrLess(Duration sessionTimeout) {
        return sessionTimeout == null || sessionTimeout.isNegative() || sessionTimeout.isZero();
    }

    protected void postProcessContext(Context context) {
        this.allowHttpMethods(context);
    }

    private void allowHttpMethods(Context context) {
        if (!this.notAllowHttpMethods.isEmpty()) {
            SecurityConstraint constraint = new SecurityConstraint();
            constraint.setUserConstraint("CONFIDENTIAL");
            SecurityCollection securityCollection = new SecurityCollection();
            securityCollection.addPattern("/*");
            for (String httpMethod : this.notAllowHttpMethods) {
                securityCollection.addMethod(httpMethod);
            }
            constraint.setAuthConstraint(true);
            constraint.addCollection(securityCollection);
            SecurityConstraint constraint2 = new SecurityConstraint();
            constraint2.setUserConstraint("NONE");
            SecurityCollection securityCollection2 = new SecurityCollection();
            securityCollection2.addPattern("/*");
            constraint2.addCollection(securityCollection2);
            context.addConstraint(constraint);
            context.addConstraint(constraint2);
        }
    }

    protected TongWebServer getTongWebServer(ServletContainer servletContainer) {
        return new TongWebServer(servletContainer, this.getPort() >= 0, this.tongWebProperties.getShutdown());
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @Override
    public void setBaseDirectory(File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public Set<String> getTldSkipPatterns() {
        return this.tldSkipPatterns;
    }

    public void setTldSkipPatterns(Collection<String> patterns) {
        Assert.notNull(patterns, (String)"Patterns must not be null");
        this.tldSkipPatterns = new LinkedHashSet<String>(patterns);
    }

    public void addTldSkipPatterns(String ... patterns) {
        Assert.notNull((Object)patterns, (String)"Patterns must not be null");
        this.tldSkipPatterns.addAll(Arrays.asList(patterns));
    }

    public void setProtocol(String protocol) {
        Assert.hasLength((String)protocol, (String)"Protocol must not be empty");
        this.protocol = protocol;
    }

    public void setEngineValves(Collection<? extends Valve> engineValves) {
        Assert.notNull(engineValves, (String)"Valves must not be null");
        this.engineValves = new ArrayList<Valve>(engineValves);
    }

    public Collection<Valve> getEngineValves() {
        return this.engineValves;
    }

    @Override
    public void addEngineValves(Valve ... engineValves) {
        Assert.notNull((Object)engineValves, (String)"Valves must not be null");
        this.engineValves.addAll(Arrays.asList(engineValves));
    }

    public Valve getSemaphore() {
        return this.semaphore;
    }

    public void setSemaphore(Valve semaphore) {
        this.semaphore = semaphore;
    }

    public Valve getAccessLog() {
        return this.accessLog;
    }

    public void setAccessLog(Valve accessLog) {
        this.accessLog = accessLog;
    }

    public RemoteFilterConfigBean getRemoteFilter() {
        return this.remoteFilter;
    }

    public void setRemoteFilter(RemoteFilterConfigBean remoteFilter) {
        this.remoteFilter = remoteFilter;
    }

    public void setContextValves(Collection<? extends Valve> contextValves) {
        Assert.notNull(contextValves, (String)"Valves must not be null");
        this.contextValves = new ArrayList<Valve>(contextValves);
    }

    public Collection<Valve> getContextValves() {
        return this.contextValves;
    }

    public void addContextValves(Valve ... contextValves) {
        Assert.notNull((Object)contextValves, (String)"Valves must not be null");
        this.contextValves.addAll(Arrays.asList(contextValves));
    }

    public void setContextLifecycleListeners(Collection<? extends LifecycleListener> contextLifecycleListeners) {
        Assert.notNull(contextLifecycleListeners, (String)"ContextLifecycleListeners must not be null");
        this.contextLifecycleListeners = new ArrayList<LifecycleListener>(contextLifecycleListeners);
    }

    public Collection<LifecycleListener> getContextLifecycleListeners() {
        return this.contextLifecycleListeners;
    }

    public void addContextLifecycleListeners(LifecycleListener ... contextLifecycleListeners) {
        Assert.notNull((Object)contextLifecycleListeners, (String)"ContextLifecycleListeners must not be null");
        this.contextLifecycleListeners.addAll(Arrays.asList(contextLifecycleListeners));
    }

    public void setTongWebContextCustomizers(Collection<? extends TongWebContextCustomizer> tongWebContextCustomizers) {
        Assert.notNull(tongWebContextCustomizers, (String)"TongwebContextCustomizers must not be null");
        this.tongWebContextCustomizers = new LinkedHashSet<TongWebContextCustomizer>(tongWebContextCustomizers);
    }

    public Collection<TongWebContextCustomizer> getTongWebContextCustomizers() {
        return this.tongWebContextCustomizers;
    }

    @Override
    public void addContextCustomizers(TongWebContextCustomizer ... tongWebContextCustomizers) {
        Assert.notNull((Object)tongWebContextCustomizers, (String)"TongwebContextCustomizers must not be null");
        this.tongWebContextCustomizers.addAll(Arrays.asList(tongWebContextCustomizers));
    }

    public void setTongWebConnectorCustomizers(Collection<? extends TongWebConnectorCustomizer> tongWebConnectorCustomizers) {
        Assert.notNull(tongWebConnectorCustomizers, (String)"TongwebConnectorCustomizers must not be null");
        this.tongWebConnectorCustomizers = new LinkedHashSet<TongWebConnectorCustomizer>(tongWebConnectorCustomizers);
    }

    @Override
    public void addConnectorCustomizers(TongWebConnectorCustomizer ... tongWebConnectorCustomizers) {
        Assert.notNull((Object)tongWebConnectorCustomizers, (String)"TongwebConnectorCustomizers must not be null");
        this.tongWebConnectorCustomizers.addAll(Arrays.asList(tongWebConnectorCustomizers));
    }

    public Collection<TongWebConnectorCustomizer> getTongWebConnectorCustomizers() {
        return this.tongWebConnectorCustomizers;
    }

    public void setTongWebProtocolHandlerCustomizers(Collection<? extends TongWebProtocolHandlerCustomizer<?>> tongWebProtocolHandlerCustomizer) {
        Assert.notNull(tongWebProtocolHandlerCustomizer, (String)"TongWebProtocolHandlerCustomizers must not be null");
        this.tongWebProtocolHandlerCustomizers = new LinkedHashSet(tongWebProtocolHandlerCustomizer);
    }

    @Override
    public void addProtocolHandlerCustomizers(TongWebProtocolHandlerCustomizer<?> ... tongWebProtocolHandlerCustomizers) {
        Assert.notNull(tongWebProtocolHandlerCustomizers, (String)"TongWebProtocolHandlerCustomizers must not be null");
        this.tongWebProtocolHandlerCustomizers.addAll(Arrays.asList(tongWebProtocolHandlerCustomizers));
    }

    public Collection<TongWebProtocolHandlerCustomizer<?>> getTongWebProtocolHandlerCustomizers() {
        return this.tongWebProtocolHandlerCustomizers;
    }

    public void addAdditionalTongWebConnectors(Connector ... connectors) {
        Assert.notNull((Object)connectors, (String)"Connectors must not be null");
        this.additionalTongWebConnectors.addAll(Arrays.asList(connectors));
    }

    public List<Connector> getAdditionalTongWebConnectors() {
        return this.additionalTongWebConnectors;
    }

    @Override
    public void setUriEncoding(Charset uriEncoding) {
        this.uriEncoding = uriEncoding;
    }

    public Charset getUriEncoding() {
        return this.uriEncoding;
    }

    @Override
    public void setBackgroundProcessorDelay(int delay) {
        this.backgroundProcessorDelay = delay;
    }

    private File getJarFileDocumentRoot() {
        return this.getArchiveFileDocumentRoot(".jar");
    }

    private File getArchiveFileDocumentRoot(String extension) {
        File file = this.getCodeSourceArchive();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Code archive: " + file));
        }
        if (file != null && file.exists() && !file.isDirectory() && file.getName().toLowerCase(Locale.ENGLISH).endsWith(extension)) {
            return file.getAbsoluteFile();
        }
        return null;
    }

    private File getCodeSourceArchive() {
        return this.getCodeSourceArchive(this.getClass().getProtectionDomain().getCodeSource());
    }

    private void initDisableMBeanRegistry() {
        this.disableMBeanRegistry = !this.tongWebProperties.getTongweb().getMbeanregistry().isEnabled();
    }

    File getCodeSourceArchive(CodeSource codeSource) {
        try {
            URL location;
            URL uRL = location = codeSource != null ? codeSource.getLocation() : null;
            if (location == null) {
                return null;
            }
            URLConnection connection = location.openConnection();
            String path = connection instanceof JarURLConnection ? ((JarURLConnection)connection).getJarFile().getName() : location.toURI().getPath();
            int index = path.indexOf("!/");
            if (index != -1) {
                path = path.substring(0, index);
            }
            return new File(path);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static final class LoaderHidingWebResourceSet
    extends AbstractResourceSet {
        private final WebResourceSet delegate;
        private final Method initInternal;

        private LoaderHidingWebResourceSet(WebResourceSet delegate) {
            this.delegate = delegate;
            try {
                this.initInternal = LifecycleBase.class.getDeclaredMethod("initInternal", new Class[0]);
                this.initInternal.setAccessible(true);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }

        public WebResource getResource(String path) {
            if (path.startsWith("/org/springframework/boot")) {
                return new EmptyResource(this.getRoot(), path);
            }
            return this.delegate.getResource(path);
        }

        public String[] list(String path) {
            return this.delegate.list(path);
        }

        public Set<String> listWebAppPaths(String path) {
            return this.delegate.listWebAppPaths(path);
        }

        public boolean mkdir(String path) {
            return this.delegate.mkdir(path);
        }

        public boolean write(String path, InputStream is, boolean overwrite) {
            return this.delegate.write(path, is, overwrite);
        }

        public URL getBaseUrl() {
            return this.delegate.getBaseUrl();
        }

        public void setReadOnly(boolean readOnly) {
            this.delegate.setReadOnly(readOnly);
        }

        public boolean isReadOnly() {
            return this.delegate.isReadOnly();
        }

        public void gc() {
            this.delegate.gc();
        }

        protected void initInternal() throws LifecycleException {
            if (this.delegate instanceof LifecycleBase) {
                try {
                    ReflectionUtils.invokeMethod((Method)this.initInternal, (Object)this.delegate);
                }
                catch (Exception ex) {
                    throw new LifecycleException((Throwable)ex);
                }
            }
        }
    }

    private static final class LoaderHidingResourceRoot
    extends StandardRoot {
        private LoaderHidingResourceRoot(TongWebEmbedContext context) {
            super((Context)context);
        }

        protected WebResourceSet createMainResourceSet() {
            return new LoaderHidingWebResourceSet(super.createMainResourceSet());
        }
    }

    private final class StaticResourceConfigurer
    implements LifecycleListener {
        private final Context context;

        private StaticResourceConfigurer(Context context) {
            this.context = context;
        }

        public void lifecycleEvent(LifecycleEvent event) {
            if (event.getType().equals("configure_start")) {
                this.addResourceJars(TongWebServletWebServerFactory.this.getUrlsOfJarsWithMetaInfResources());
            }
        }

        private void addResourceJars(List<URL> resourceJarUrls) {
            for (URL url : resourceJarUrls) {
                String path = url.getPath();
                if (path.endsWith(".jar") || path.endsWith(".jar!/")) {
                    String jar = url.toString();
                    if (!jar.startsWith("jar:")) {
                        jar = "jar:" + jar + "!/";
                    }
                    this.addResourceSet(jar);
                    continue;
                }
                this.addResourceSet(url.toString());
            }
        }

        private void addResourceSet(String resource) {
            try {
                if (this.isInsideNestedJar(resource)) {
                    resource = resource.substring(0, resource.length() - 2);
                }
                URL url = new URL(resource);
                String path = "/META-INF/resources";
                this.context.getResources().createWebResourceSet(WebResourceRoot.ResourceSetType.RESOURCE_JAR, "/", url, path);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private boolean isInsideNestedJar(String dir) {
            return dir.indexOf("!/") < dir.lastIndexOf("!/");
        }
    }

    private static class DisablePersistSessionListener
    implements LifecycleListener {
        private DisablePersistSessionListener() {
        }

        public void lifecycleEvent(LifecycleEvent event) {
            Context context;
            Manager manager;
            if (event.getType().equals("start") && (manager = (context = (Context)event.getLifecycle()).getManager()) != null && manager instanceof StandardManager) {
                ((StandardManager)manager).setPathname(null);
            }
        }
    }
}

