package com.testor.common.constant;

import com.testor.common.util.CodeEnum;
import lombok.Getter;

/**
 * @author zhangyangfan@testor.com.cn
 * @version 1.0
 * @description: 流程状态
 * @date 2022/5/11 18:42
 */
@Getter
public enum ProcessStatus implements CodeEnum {

    SUBMIT("3", "待审核"),
//    TO_BE_REVIEWED("4", "草稿"),
    PASSED("5", "审核通过"),
    REVOKE("6", "终止"),
    REJECT("7", "驳回"),
    ;
    private String code;

    private String msg;

    ProcessStatus(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }
}
