package com.testor.ddd.safetyControl.infrastructure.client.funConfClient;

import com.tongtech.tfw.backend.common.biz.models.BaseResponse;

public interface TableNumClient {

    /**
     * 获取某表、某字段 当前的最大数值
     * @param tableName
     * @param fieldName
     * @return
     */
    Integer obtainMaxNum(String tableName, String fieldName);

    /**
     * 修改保存 表、字段的当前最大值
     * @param tableName
     * @param fieldName
     * @param maxNum
     * @return
     */
    BaseResponse saveMaxNum(String tableName, String fieldName, Integer maxNum);

    /**
     * 替换 匹配的fieldName
     * @param table
     * @param oldFieldName
     * @param newFieldName
     */
    Integer replaceFieldName(String table, String oldFieldName, String newFieldName);

}
