package com.testor.ddd.safetyControl.infrastructure.repository.riskMap.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;


/**
 * 风险地图对象 t_safe_risk_map
 * 
 * @author testor-framework
 * @date 2022-10-05 15:18:02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_safe_risk_map")
@ApiModel(value = "TSafeRiskMap对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TSafeRiskMapDO extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * id
 */
  @ApiModelProperty(value = "id")
  @TableId(value = "id",type = IdType.ASSIGN_UUID)
  private String id;
/**
 * 组织结构id
 */
  @ApiModelProperty(value = "组织结构id")

  @TableField("org_id")
  private String orgId;
/**
 * 名称
 */
  @ApiModelProperty(value = "名称")

  @TableField("name")
  private String name;
/**
 * 地图层级(1-企业；2-车间场所；3-作业区域)
 */
  @ApiModelProperty(value = "地图层级(1-企业；2-车间场所；3-作业区域)" , example = "0")

  @TableField("\"level\"")
  private Integer level;
/**
 * 空间id
 */
  @ApiModelProperty(value = "空间id")

  @TableField("space_id")
  private String spaceId;
/**
 * 底图id
 */
  @ApiModelProperty(value = "底图id")

  @TableField("image_id")
  private String imageId;

  @ApiModelProperty(value = "区域公司id")
  @TableField("region_org_id")
  private String regionOrgId;

  @ApiModelProperty(value = "基层单位id")
  @TableField("basic_org_id")
  private String basicOrgId;

  public static final String ID ="id";
  public static final String ORG_ID ="org_id";
  public static final String NAME ="name";
  public static final String LEVEL ="\"level\"";
  public static final String SPACE_ID ="space_id";
  public static final String IMAGE_ID ="image_id";


}
