package com.testor.ddd.safetyControl.interfaces.controller;

import com.testor.ddd.safetyControl.application.service.spaceManage.SpaceManageService;
import com.testor.ddd.safetyControl.infrastructure.uitls.SpaceExcelTemplate.DownloadSpaceTemplateUtil;
import com.testor.ddd.safetyControl.interfaces.model.dto.space.TSafeSpaceDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.space.TSafeSpaceDTOParam;
import com.testor.ddd.safetyControl.interfaces.model.dto.space.TSafeSpaceDelParam;
import com.testor.ddd.safetyControl.interfaces.model.vo.space.TSafeSpaceVO;
import com.testor.module.notice.model.domain.TreeVO;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.common.models.sys.UserInfo;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 空间场所Controller
 *
 * @author testor-framework
 * @date 2022-06-27 16:56:21
 */
@RestController
@RequestMapping("/space/space")
@Api(value = "TSafeSpace", tags = "空间场所")
@Slf4j
public class TSafeSpaceController extends SuperController
{
    @Resource
    private SpaceManageService spaceManageService;

	@Resource
	private DownloadSpaceTemplateUtil downloadSpaceTemplateUtil;

    /* Generated Method*/
	@ApiOperation(value = "新增、修改空间场所", notes = "Add TSafeSpace")
	@PostMapping(value = "/add")
	public BaseResponse addEntity(@RequestBody TSafeSpaceDTO addRequest) {
		return spaceManageService.editSpace(addRequest);
	}

	@ApiOperation(value = "删除 空间场所 ", notes = "delete TSafeSpace By Id")
	@PutMapping(value = "/delete")
	public BaseResponse deleteEntity(@RequestBody TSafeSpaceDelParam deleteRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&& StringHelper.isNotEmpty(deleteRequest.getId())){
			baseResponse= spaceManageService.deleteById(deleteRequest.getLevel(), deleteRequest.getId());
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 空间场所 分页列表", notes = "List TSafeSpace with page")
	@GetMapping(value = "/list")
	public  BaseResponse<BaseResponseList<TSafeSpaceVO>>listEntity(TSafeSpaceDTOParam param){
		BaseResponse<BaseResponseList<TSafeSpaceVO>>baseResponse=new BaseResponse<>();
		BaseResponseList<TSafeSpaceVO> resultList= spaceManageService.listByPage(param);
		baseResponse.setData(resultList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 空间场所 树形列表", notes = "TreeList TSafeSpace")
	@GetMapping(value = "/getTreeList")
	public  BaseResponse<List<TreeVO>> getTreeList(String orgId){
		BaseResponse<List<TreeVO>> baseResponse=new BaseResponse<>();
		List<TreeVO> tree = spaceManageService.getTree(orgId);
		baseResponse.setData(tree);
		return baseResponse;
	}

	@ApiOperation(value = "下载车间场所模板（车间场所信息批量导入模板_1657102103080.xlsx）")
	@GetMapping(value = "/downloadTemplate")
	public void downloadTemplate(HttpServletResponse response, String fileDowName) {
		UserInfo curUser = ContextUtils.getLoginUser();
		String curUserOrgId = curUser.getOrgId();
		//spaceExcelUtil.downloadWorkshopTemplate(response, "车间场所信息批量导入模板_1656988142789.xlsx", curUserOrgId);
		downloadSpaceTemplateUtil.downloadWorkshopTemplate(response, fileDowName, curUserOrgId);

	}

	@ApiOperation(value = "下载作业区域模板（作业区域信息批量导入模板_1657159438491.xlsx）")
	@GetMapping(value = "/downloadWorkareaTemplate")
	public void downloadWorkareaTemplate(HttpServletResponse response, String fileDowName) {
		UserInfo curUser = ContextUtils.getLoginUser();
		String curUserOrgId = curUser.getOrgId();
		downloadSpaceTemplateUtil.downloadWorkareaTemplate(response, fileDowName, curUserOrgId);

	}

	@ApiOperation(value = "测试导出 ")
	@GetMapping(value = "/testExport")
	public void testExport(HttpServletResponse response) {
		downloadSpaceTemplateUtil.exportModelExcel(response);

	}

	@ApiOperation(value = "导入车间场所", notes = "")
	@PostMapping("/importWorkshop")
	public BaseResponse<String> importWorkshop(@RequestParam("file") MultipartFile file) throws Exception {
		return spaceManageService.importWorkshop(file);
	}

	@ApiOperation(value = "导入作业区域", notes = "")
	@PostMapping("/importWorkarea")
	public BaseResponse<String> importWorkarea(@RequestParam("file") MultipartFile file) throws Exception {
		return spaceManageService.importWorkarea(file);
	}

}
