package com.testor.ddd.safetyControl.interfaces.model.dto.equipment;

import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;


/**
 * 设备系统类型/设备类型对象 t_safe_equipment_type
 * 
 * @author testor-framework
 * @date 2022-07-02 11:02:02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_safe_equipment_type")
@ApiModel(value = "TSafeEquipmentType对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TSafeEquipmentTypeDTO extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * id
 */
  @ApiModelProperty(value = "id")
  private String id;
/**
 * 组织机构id
 */
  @ApiModelProperty(value = "组织机构id")
  private String orgId;
/**
 * 父级id(系统类型时此值为0，设备类型时此值为系统类型id)
 */
  @ApiModelProperty(value = "父级id(系统类型时此值为0，设备类型时此值为系统类型id)(编辑必填: 添加系统类型时，此值传0)")
  private String parentId;
/**
 * 名称
 */
  @ApiModelProperty(value = "名称(编辑必填)")
  private String name;
/**
 * 编码
 */
  @ApiModelProperty(value = "编码(编辑必填)")
  private String code;
}
