package com.testor.module.ZLOA.sysUserOA.model.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;

/**
 * @author rsq
 * @program zlmy_boot
 * @return
 **/
@Data
public class LoginDto {

    @ApiModelProperty("登录名")
    @NotBlank(message = "账号不能为空")
    private String loginname;

    @ApiModelProperty("密码")
    @NotBlank(message = "密码不能为空")
    @Size(min = 8,max = 16,message = "密码长度不规范")
    private String password;

    @ApiModelProperty("验证码id")
    private String uuid;

    @ApiModelProperty("验证码")
    @NotBlank(message = "验证码不能为空")
    private String captcha;

    /**
     * 用于切换到E+后支持在浏览器进行调试
     */
    @ApiModelProperty("登录方式 0正常登录 1调试登录")
    private String type;

}
