package com.testor.module.accident.model.resp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author zhangyangfan@testor.com.cn
 * @version 1.0
 * @description: 上报单位
 * @date 2022/5/11 14:59
 */
@Data
@ApiModel(value = "事故报告上报单位", description = "")
public class ReportUnitResp {

    @ApiModelProperty(value = "一级部门id")
    private String firstLevelDepartmentId;

    @ApiModelProperty(value = "区域公司id")
    private String regionalCompanyId;

    @ApiModelProperty(value = "基层单位id")
    private String basicUnitId;

    @ApiModelProperty(value = "一级部门")
    private String firstLevelDepartment;

    @ApiModelProperty(value = "大区")
    private String regionalCompany;

    @ApiModelProperty(value = "基层单位")
    private String basicUnit;

    @ApiModelProperty(value = "部门全路径(带自身部门)")
    private String parentIds;

    @ApiModelProperty(value = "部门前三层级ids")
    private String pathIds;

    @ApiModelProperty(value = "部门前三层级名称")
    private String path;

    @ApiModelProperty(value = "企业性质")
    private String nature;

    @ApiModelProperty(value = "企业层级")
    private BigDecimal treeLevel;

    @ApiModelProperty(value = "子部门层级名称（不包含一级机构）")
    private String subSectorPath;

    @ApiModelProperty(value = "子部门层级名称（不包含一级机构）")
    private String subSectorPathIds;

//    @ApiModelProperty(value = "第三层单位，如果与基层单位相同则不存数据")
//    private String lastUnitId;
//
//    @ApiModelProperty(value = "第三层单位，如果与基层单位相同则不存数据")
//    private String lastLevelUnit;
}
