package com.testor.module.hazard.model.domain;

import java.time.LocalDateTime;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;


/**
 * 危险作业许可证-现场确认记录对象 t_hazard_license_site_confirmation
 * 
 * @author testor-framework
 * @date 2024-12-26 10:53:13
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_hazard_license_site_confirmation")
@ApiModel(value = "THazardLicenseSiteConfirmation对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class THazardLicenseSiteConfirmation extends SuperModel
{
    private static final long serialVersionUID = 1L;

  @TableId("id")
  private String id;
/**
 * 计划id
 */
  @ApiModelProperty(value = "计划id")

  @TableField("plan_id")
  private String planId;
/**
 * 许可证id
 */
  @ApiModelProperty(value = "许可证id")

  @TableField("license_id")
  private String licenseId;
/**
 * 1=作业所在部门,2=作业主管部门,3=安全管理部门,4=主管部门负责人,5=公司级分管领导负责人,6=公司级安环部,7=安全分管领导或主要负责人
 */
  @ApiModelProperty(value = "1=作业所在部门,2=作业主管部门,3=安全管理部门,4=主管部门负责人,5=公司级分管领导负责人,6=公司级安环部,7=安全分管领导或主要负责人")

  @TableField("type")
  private String type;
/**
 * 是否指派现场确认人 0=否,1=是
 */
  @ApiModelProperty(value = "是否指派现场确认人 0=否,1=是")

  @TableField("is_on_site_assignee")
  private String isOnSiteAssignee;
/**
 * 指派现场确认人
 */
  @ApiModelProperty(value = "指派现场确认人")

  @TableField("assign_site_confirmor")
  private String assignSiteConfirmor;
/**
 * 确认结果 0=通过,1驳回
 */
  @ApiModelProperty(value = "确认结果 0=通过,1驳回")

  @TableField("confirmation_result")
  private String confirmationResult;
/**
 * 确认意见
 */
  @ApiModelProperty(value = "确认意见")

  @TableField("confirmation_opinion")
  private String confirmationOpinion;
/**
 * 现场图片
 */
  @ApiModelProperty(value = "现场图片")

  @TableField("site_images")
  private String siteImages;

  public static final String ID ="id";
  public static final String PLAN_ID ="plan_id";
  public static final String LICENSE_ID ="license_id";
  public static final String TYPE ="type";
  public static final String IS_ON_SITE_ASSIGNEE ="is_on_site_assignee";
  public static final String ASSIGN_SITE_CONFIRMOR ="assign_site_confirmor";
  public static final String CONFIRMATION_RESULT ="confirmation_result";
  public static final String CONFIRMATION_OPINION ="confirmation_opinion";
  public static final String SITE_IMAGES ="site_images";


}
