package com.testor.module.hazard.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.hazard.dao.THazardWorkPlanCheckDao;
import com.testor.module.hazard.dao.THazardWorkPlanMonitoringRecordDao;
import com.testor.module.hazard.dao.THazardWorkPlanMonitoringRecordProjectDao;
import com.testor.module.hazard.model.domain.TContractorAccessLogApproval;
import com.testor.module.hazard.model.domain.THazardWorkPlanCheck;
import com.testor.module.hazard.model.domain.THazardWorkPlanMonitoringRecord;
import com.testor.module.hazard.model.dto.TContractorAccessLogApprovalParam;
import com.testor.module.hazard.model.dto.THazardWorkPlanMonitoringRecordParam;
import com.testor.module.hazard.service.THazardWorkPlanCheckService;
import com.testor.module.hazard.service.THazardWorkPlanMonitoringRecordService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class THazardWorkPlanMonitoringRecordServiceImpl extends SuperServiceImpl<THazardWorkPlanMonitoringRecordDao, THazardWorkPlanMonitoringRecord> implements THazardWorkPlanMonitoringRecordService {

    @Autowired
    private THazardWorkPlanMonitoringRecordProjectDao hazardWorkPlanMonitoringRecordProjectDao;

    @Override
    public Page<THazardWorkPlanMonitoringRecord> selectPage(THazardWorkPlanMonitoringRecordParam param) {

        Long page =
                StringHelper.isEmpty(param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit =
                StringHelper.isEmpty(param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page<THazardWorkPlanMonitoringRecord> resultPage = new Page<>(page, limit); // 修改此处泛型类型
        QueryWrapper<THazardWorkPlanMonitoringRecord> queryWrapper = this.createQuery(param);
        Page<THazardWorkPlanMonitoringRecord> tHazardWorkPlanMonitoringRecordPage = this.page(resultPage, queryWrapper);
        tHazardWorkPlanMonitoringRecordPage.getRecords().forEach(   tHazardWorkPlanMonitoringRecord -> {
            tHazardWorkPlanMonitoringRecord.setProjectList(
                    hazardWorkPlanMonitoringRecordProjectDao.selectByRecordId(tHazardWorkPlanMonitoringRecord.getId()));
        });
        return tHazardWorkPlanMonitoringRecordPage;
    }

    @Transactional
    @Override
    public void insertContractorAccessLogApproval(THazardWorkPlanMonitoringRecord hazardWorkPlanMonitoringRecord) {
        this.baseMapper.insert(hazardWorkPlanMonitoringRecord);
        if(hazardWorkPlanMonitoringRecord.getProjectList() != null && !hazardWorkPlanMonitoringRecord.getProjectList().isEmpty()) {
            hazardWorkPlanMonitoringRecord.getProjectList().forEach(project -> {
                project.setHazardWorkPlanMonitoringRecordId(hazardWorkPlanMonitoringRecord.getId());
                hazardWorkPlanMonitoringRecordProjectDao.insert(project);
            });
        }
    }

    private QueryWrapper<THazardWorkPlanMonitoringRecord> createQuery(THazardWorkPlanMonitoringRecordParam queryParam) {
        QueryWrapper<THazardWorkPlanMonitoringRecord> queryWrapper = new QueryWrapper<>();
        if (StringHelper.isNotEmpty(queryParam.getPlanId())) {
            queryWrapper.eq("plan_id", queryParam.getPlanId());
        }
        queryWrapper.orderByDesc(THazardWorkPlanMonitoringRecord.CREATE_DATE);
        return queryWrapper;
    }

}
