package com.testor.module.hire.entity.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.Date;

/**
 * @author caq
 * @date 2024/8/30
 * @description 租赁库列表对象
 */
@Getter
@Setter
@Accessors(chain = true)
@ApiModel(value = "HireDepositoryDto对象", description = "租赁库列表数据库对象")
public class HireDepositoryDto {
    @ApiModelProperty(value = "ID")
    private String id;

    /**
     * 所属单位id
     */
    private String lessorOrgId;

    /**
     * 所属单位
     */
    private String lessorOrgName;

    /**
     * 父级所属单位
     */
    private String lessorParentOrgName;

    /**
     * 父级所属单位id
     */
    private String lessorParentOrgId;

    @ApiModelProperty(value = "出租方简称")
    private String lessorShortName;

    @ApiModelProperty(value = "库点全称")
    private String depositoryFullName;

    @ApiModelProperty(value = "存粮地址")
    private String depositoryAddress;

    @ApiModelProperty(value = "租赁方式code")
    private String accessLeaseMethodCode;

    @ApiModelProperty(value = "租赁方式text")
    private String accessLeaseMethodName;

    @ApiModelProperty(value = "租赁类型code")
    private String accessLeaseTypeCode;

    @ApiModelProperty(value = "租赁类型text")
    private String accessLeaseTypeName;

    @ApiModelProperty(value = "租赁仓容")
    private String accessLeaseCapacity;

    @ApiModelProperty(value = "库点状态 0启用 2停用")
    private String accessStatus;

    @ApiModelProperty(value = "租赁开始时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date accessHireStartTime;

    @ApiModelProperty(value = "租赁结束时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date accessHireEndTime;




}
