package com.testor.module.notice.dao;

import com.testor.module.notice.model.domain.TSysOrg;
import com.testor.module.notice.model.domain.TreeVO;
import com.tongtech.tfw.backend.common.models.supers.SuperDao;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * noticeMapper接口
 *
 * @author tong-framework
 * @date 2022-04-27 18:10:12
 */
@Mapper
public interface TSysOrgDao extends SuperDao<TSysOrg> {
    List<TSysOrg> getOrg();
    List<TreeVO> selectAllTree(@Param("id") String id) ;

    List<TreeVO> findTreeByPid(@Param("id") Integer id) ;

    List<String> selectAllSubId(@Param("orgIds") List<String> orgIds);

    List<String> selectOrgIdAllSubId(@Param("orgId") String orgId);

    /**
     * 查询租赁库数据
     * @return
     */
    List<TSysOrg> selectIsRent();

    /**
     * 查询租赁库下有部门的数据
     * @return
     */
    List<TSysOrg> selectIsRentDept();

    @Select("select * from t_sys_org\n" +
            "where parent_id = #{orgId} and status = '0' and is_dept='0' or org_id = #{orgId}")
    List<TSysOrg> selectOrgNameByParentId(@Param("orgId") String orgId);

    /**
     * 查询父级下所有子级组织id
     * @param orgId
     * @return
     */
    List<String> selectOrgIdByParentId(@Param("orgId") String orgId);



}
