package com.testor.module.partner.dao;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.partner.model.domain.TPartnerOrg;
import com.testor.module.partner.model.dto.TPartnerOrgDTO;
import com.testor.module.partner.model.dto.TPartnerOrgParam;
import com.testor.module.partner.model.excel.PartnerReport;
import com.testor.module.partner.model.vo.PartnerOrgBlacklistVO;
import com.testor.module.partner.model.vo.PartnerOrgDetailVO;
import com.testor.module.partner.model.vo.PartnerOrgVO;
import com.tongtech.tfw.backend.common.models.supers.SuperDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 相关方组织机构Mapper接口
 *
 * @author testor-framework
 * @date 2022-06-01 14:16:53
 */
public interface TPartnerOrgDao extends SuperDao<TPartnerOrg> {

    List<TPartnerOrgDTO> getResid(@Param("query")TPartnerOrgDTO tPartnerOrgDTO) ;

    /**
     * @param obj
     * @return
     */
    List<PartnerReport> findPartnerExportData(@Param("query") List<String> query);

    IPage<PartnerOrgVO> list(Page<PartnerOrgVO> page, @Param("query") TPartnerOrgParam query);

    PartnerOrgDetailVO detail(@Param("resId") String resId);

    IPage<PartnerOrgBlacklistVO> blacklist(Page<PartnerOrgBlacklistVO> page, @Param("query") TPartnerOrgParam query);

    List<TPartnerOrgDTO> getOrgId(@Param("query") TPartnerOrgDTO tPartnerOrgDTO);
}
