package com.testor.module.partner.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;


/**
 * 现场作业统计对象 t_job_statistics
 * 
 * @author testor-framework
 * @date 2022-11-02 10:42:06
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_job_statistics")
@ApiModel(value = "TJobStatistics对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TJobStatistics extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * 作业状态
 */
  @ApiModelProperty(value = "作业状态")

  @TableField("DHZY_ZYZT")
  private String dhzyZyzt;
/**
 * 单位名称
 */
  @ApiModelProperty(value = "单位名称")

  @TableField("DHZY_GCMZ")
  private String dhzyGcmz;
/**
 * 租赁单位
 */
  @ApiModelProperty(value = "租赁单位")

  @TableField("DHZY_ZKSSPRY")
  private String dhzyZksspry;
/**
 * 是否为租赁单位
 */
  @ApiModelProperty(value = "是否为租赁单位")

  @TableField("SFZYK")
  private String sfzyk;
/**
 * 相关方单位作业人数
 */
  @ApiModelProperty(value = "相关方单位作业人数" , example = "0")

  @TableField("XGFDWRY")
  private Long xgfdwry;
/**
 * 作业结束时间
 */
  @ApiModelProperty(value = "作业结束时间")

  @TableField("DHZY_ZYJSSJ")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date dhzyZyjssj;
/**
 * 作业开始时间
 */
  @ApiModelProperty(value = "作业开始时间")

  @TableField("DHZY_ZYKSSJ")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date dhzyZykssj;
/**
 * 作业类型
 */
  @ApiModelProperty(value = "作业类型")

  @TableField("DHZY_ZYLB")
  private String dhzyZylb;
/**
 * 图案数据唯一标识
 */
  @ApiModelProperty(value = "图案数据唯一标识")

  @TableField("dhzy_id")
  private String dhzyId;
/**
 * 父级id
 */
  @ApiModelProperty(value = "父级id")

  @TableField("parent_id")
  private String parentId;
/**
 * id
 */
  @ApiModelProperty(value = "id")

  @TableId("id")
  private String id;
/**
 * 组织机构id
 */
  @ApiModelProperty(value = "组织机构id")

  @TableField("org_id")
  private String orgId;
/**
 * 公司code值
 */
  @ApiModelProperty(value = "公司code值")

  @TableField("code")
  private String code;
  /**
   *所有父级机构主键以英文逗号隔开如：一级，二级等
   */
  @ApiModelProperty(value = "所有父级机构主键以英文逗号隔开如：一级，二级等")
  @TableField("org_all_path")
  private String orgAllPath;


  public static final String DHZY_ZYZT ="DHZY_ZYZT";
  public static final String DHZY_GCMZ ="DHZY_GCMZ";
  public static final String DHZY_ZKSSPRY ="DHZY_ZKSSPRY";
  public static final String SFZYK ="SFZYK";
  public static final String XGFDWRY ="XGFDWRY";
  public static final String DHZY_ZYJSSJ ="DHZY_ZYJSSJ";
  public static final String DHZY_ZYKSSJ ="DHZY_ZYKSSJ";
  public static final String DHZY_ZYLB ="DHZY_ZYLB";
  public static final String DHZY_ID ="dhzy_id";
  public static final String PARENT_ID ="parent_id";
  public static final String ID ="id";
  public static final String ORG_ID ="org_id";
  public static final String CODE ="code";


}
