package com.testor.module.partner.model.excel;

import com.alibaba.excel.annotation.ExcelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.Date;

/**
 * 相关方机构导出列表
 */
@Data
public class PartnerStaffExp {

    @ApiModelProperty("序号")
    @ExcelProperty(value = {"序号"}, index = 0)
    private int serialNumber;

    /**
     * 组织机构id
     */
    @ApiModelProperty(value = "id")
    private String id;

    /**
     * 组织机构id
     */
    @ApiModelProperty(value = "姓名")
    private String name;

    @ApiModelProperty(value = "性别 0-女 1-男")
    private String sex;

    @ApiModelProperty(value = "身份证号")
    private String idcard;

    @ApiModelProperty(value = "phone")
    private String phone;

    @ApiModelProperty(value = "相关方机构id")
    private String partnerId;

    @ApiModelProperty(value = "所属单位（相关方机构id）")
    private String partnerName;

    @ApiModelProperty(value = "工种")
    private String workType;

    @ApiModelProperty(value = "资质名称")
    private String certificateName;

    @ApiModelProperty(value = "资质证件编号")
    private String certificateCode;
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "有效期至")
    private Date certificateValidEndDate;


    @ApiModelProperty(value = "资质证件备注")
    private String certificateRemarks;

}
