package com.testor.module.partner.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.testor.common.constant.StatusEnum;
import com.testor.module.partner.dao.TPartnerOrgResDao;
import com.testor.module.partner.model.domain.TPartnerOrgRes;
import com.testor.module.partner.model.dto.TPartnerOrgResDTO;
import com.testor.module.partner.service.TPartnerOrgResService;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.constants.enumeration.BaseStatusEnum;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import com.tongtech.tfw.backend.common.models.sys.UserInfo;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.Date;

/**
 * 相关方组织负责人Service业务层处理
 *
 * @author testor-framework
 * @date 2022-06-27 16:04:14
 */
@Service
public class TPartnerOrgResServiceImpl extends SuperServiceImpl<TPartnerOrgResDao, TPartnerOrgRes> implements TPartnerOrgResService {
    @Autowired(required = false)
    private TPartnerOrgResDao tPartnerOrgResDao;

    @Override
    public BaseResponse<TPartnerOrgRes> addOrdRes(TPartnerOrgResDTO tPartnerOrgResDTO) {
        BaseResponse<TPartnerOrgRes> baseResponse = new BaseResponse<>();

        UserInfo curUser = ContextUtils.getLoginUser();
        if (StrUtil.isBlank(curUser.getOrgId())) {
            baseResponse.setCode(BaseStatusEnum.UN_DATA.code());
            baseResponse.setMsg("用户信息错误");
            return baseResponse;
        }
        // 组织机构id
        String curUserOrgId = curUser.getOrgId();

        String partnerId = tPartnerOrgResDTO.getPartnerId();
        if (judgeRepeat(curUserOrgId, partnerId)) {
            baseResponse.setCode(BaseStatusEnum.UNKNOWN.code());
            baseResponse.setMsg("重复添加");
            return baseResponse;
        }
        TPartnerOrgRes data = BeanHelper.beanToBean(tPartnerOrgResDTO, TPartnerOrgRes.class);
        data.setOrgId(curUserOrgId);
        data.setStatus(StatusEnum.USE.getCode());
        // 资质状态（0-异常，1-正常） 初始默认 1
        data.setCertificateStatus(1);

        boolean save = save(data);
        if (save) {
            baseResponse.setData(data);
        }
        return baseResponse;

    }

    @Override
    public BaseResponse<BizGeneralResponse> update(TPartnerOrgResDTO updateRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(updateRequest) && StringHelper.isNotEmpty(updateRequest.getId())) {
            UserInfo curUser = ContextUtils.getLoginUser();
            if (StrUtil.isBlank(curUser.getOrgId())) {
                baseResponse.setCode(BaseStatusEnum.UN_DATA.code());
                baseResponse.setMsg("用户信息错误");
                return baseResponse;
            }
            // 组织机构id
            String curUserOrgId = curUser.getOrgId();
            TPartnerOrgRes data = BeanHelper.beanToBean(updateRequest, TPartnerOrgRes.class);
            data.setOrgId(curUserOrgId);
            data.setUpdateBy(curUser.getUserId());
            data.setUpdateDate(new Date());
            boolean result = updateById(data);
            baseResponse.setData(
                    BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }

    /**
     * 判断是否重复添加
     *
     * @param curUserOrgId 组织机构id
     * @param partnerId    相关方id
     * @return ture-存在/false-不存在
     */
    public boolean judgeRepeat(String curUserOrgId, String partnerId) {
        QueryWrapper<TPartnerOrgRes> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("org_id", curUserOrgId).eq("partner_id", partnerId).eq("status", StatusEnum.USE.getCode());
        return count(queryWrapper) > 0;

    }
}
