package com.testor.module.regime.model.dto;

import com.testor.biz.file.model.dto.FileDTO;
import com.testor.module.regime.model.domain.TRegimeData;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 制度资料管理 删除参数对象
 *
 * @author testor-framework
 * @date 2022-07-01 14:14:14
 */

@Data
@ApiModel(value = "TRegimeData 列表查询参数对象")
@EqualsAndHashCode(callSuper = true)
public class TRegimeDataParam extends TRegimeData {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "每页数量")
    private String limit;

    @ApiModelProperty(value = "当前页数")
    private String page;

    @ApiModelProperty(value = "排序字段")
    private String orderBy;

    @ApiModelProperty(value = "排序方式")
    private String orderType;

    @ApiModelProperty(value = "开始时间")
    private String startTime;

    @ApiModelProperty(value = "结束时间")
    private String endTime;

    @ApiModelProperty(value = "用于返回多个附件")
    private List<FileDTO> fileDTOS;

    @ApiModelProperty("企业性质-发布层级")
    private String companyNature;

    @ApiModelProperty("制度材料类型列表")
    private List<String> oneMaterialsTypeList;


    @ApiModelProperty("制度材料类型列表")
    private List<String> senMaterialsTypeList;

}
