package com.testor.module.report.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

@Data
public class AccidentDto {
    //基层单位id
    private String basicUnitId ;
    //区域公司id
    private String regionalCompanyId ;
    //事故时间
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date accidentTime ;
    //假日类型
    private String fakeType ;
    //事故等级
    private String accidentLevel ;
    //事故类型
    private String accidentType ;
    //合计经济损失
    private BigDecimal totalEconomicLoss ;
    //直接经济损失
    private BigDecimal directEconomicLoss ;
    //间接经济损失
    private BigDecimal indirectEconomicLoss ;
    // 事故经过
    private String accidentPassed ;
    //事故原因
    private String accidentCause ;
    //改善措施
    private String improvements ;
    //备注
    private String remarks ;
    //人员信息
//    private List<AccidentUser> person ;
    private String person ;

    private String id ;
}
