package com.testor.module.report.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.testor.biz.sys.org.service.SysOrgService;
import com.testor.module.accident.manager.AccidentPersonnelManager;
import com.testor.module.accident.model.excel.AccidentExport;
import com.testor.module.accident.model.req.AccidentReportExportReq;
import com.testor.module.accident.service.AccidentReportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component("accidentUserService")
public class AccidentUserService {
    @Autowired
    private AccidentReportService accidentReportService;
    @Autowired
    private AccidentPersonnelManager accidentPersonnelManager;
    @Autowired
    private SysOrgService sysOrgService;

    public List<AccidentExport> getAccident(String dsName, String datasetName, Map<String, Object> parameters) throws Exception {
        String s = JSON.toJSONString(parameters);
        AccidentReportExportReq parse = JSONObject.parseObject(s, AccidentReportExportReq.class);
        List<AccidentExport> accidentExportList = accidentReportService.export(parse);
        return accidentExportList;
    }
}
