package com.testor.module.safe.service;


import com.testor.module.safe.model.domain.TSafeHazardOption;
import com.testor.module.safe.model.vo.TSafeHazardOptionVO;
import com.tongtech.tfw.backend.common.models.supers.SuperService;

import java.util.List;

/**
 * 隐患巡检排查标准细则Service接口
 *
 * @author testor-framework
 * @date 2022-07-27 14:48:44
 */
public interface TSafeHazardOptionService extends SuperService<TSafeHazardOption> {

    /**
     * 获取当前标准下检查内容信息
     *
     * @param id 标准id
     * @return list
     */
    List<TSafeHazardOptionVO> getCheckContent(String id);

    /**
     * 获取标准下所有细则
     *
     * @param id 标准id
     * @return list
     */
    List<TSafeHazardOptionVO> getRulesList(String id);

}
