package com.testor.module.safeCheck.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import com.testor.module.safeCheck.model.domain.TSafeCheckOrg;

/**
 * 安全检查计划和被检查机构关系 删除参数对象
 *
 * @author rsq
 * @date 2024-09-03 08:04:16
 */

@Data
@ApiModel(value = "TSafeCheckOrg 列表查询参数对象")
@EqualsAndHashCode(callSuper = true)
public class TSafeCheckOrgParam extends TSafeCheckOrg {
	private static final long serialVersionUID = 1L;
	@ApiModelProperty(value = "每页数量")
	private String limit;

	@ApiModelProperty(value = "当前页数")
	private String page;

	@ApiModelProperty(value = "排序字段")
	private String orderBy;

	@ApiModelProperty(value = "排序方式")
	private String orderType;

}
