package com.testor.module.sys.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.testor.biz.sys.dict.data.controller.SysDictDataController;
import com.testor.biz.sys.dict.data.model.domain.SysDictData;
import com.testor.biz.sys.dict.data.model.dto.SysDictDataRequest;
import com.testor.biz.sys.dict.data.model.dto.SysDictDataResponse;
import com.testor.biz.sys.dict.data.service.SysDictDataService;
import com.testor.biz.sys.dict.type.model.domain.SysDictType;
import com.testor.biz.sys.dict.type.service.SysDictTypeService;
import com.testor.biz.util.CacheDicUtils;
import com.testor.module.sys.DictEnumCode;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @title SysDictDataController
 * @description <TODO description class purpose>
 * @Author: qiao
 * @version:1.0.0
 * @create：7/31/23 4:37 PM
 */
@RestController
@Api(value = "Dict Controllers", tags = {"字典管理模块"})
@RequestMapping({"/sys/dict"})
@Slf4j
class SysDictDataControllerS {
    @Autowired
    private SysDictDataService sysDictDataService;
    @Autowired
    private SysDictTypeService sysDictTypeService;

    SysDictDataController sysDictDataController;



    @ApiOperation(
            value = "新增字典数据键值",
            notes = "新增字典数据键值 Add SysDictData"
    )
    @PostMapping({"/add"})
    public BaseResponse<SysDictDataResponse> addEntity(@RequestBody SysDictDataRequest addRequest) {
        BaseResponse<SysDictDataResponse> baseResponse = new BaseResponse();
        //ToDo 参数校验
        if (ObjectHelper.isNotEmpty(addRequest)) {
            if (StringHelper.isEmpty(addRequest.getDictId())) {
                throw new ApiException(DictEnumCode.UN_DICT_TYPE.transform());
            }
            //ToDo 校验字典值是否重复
            int counter = this.sysDictDataService.count(new QueryWrapper<SysDictData>().ne("status", "1")
                    .eq("dict_id", addRequest.getDictId())
                    .eq("dict_key", addRequest.getDictKey()));
            if (counter > 0) {
                throw new ApiException(DictEnumCode.DICT_DATA_EXISTED_TWO.transform());
            }

            if (StringHelper.isEmpty(addRequest.getParentId())) {
                addRequest.setParentId("0");
            }
            //ToDo 参数组装保存字典值
            addRequest.setDictDataId(IdHelper.getId32bit());
            SysDictData data = BeanHelper.beanToBean(addRequest, SysDictData.class);
            data.setParentIds(this.queryParentsIds(addRequest.getParentId()));
            boolean save = this.sysDictDataService.save(data);
            if (save) {
                SysDictType sysDictType = this.sysDictTypeService.getById(addRequest.getDictId());
                CacheDicUtils.set(sysDictType.getDictType(), data.getDictKey(), data.getDictValue());
            }
            baseResponse.setData(SysDictDataResponse.builder().dictDataId(data.getDictDataId()).build());
        }

        return baseResponse;
    }

    private String queryParentsIds(String pid) {
        String pids = pid;
        if ("0".equals(pid)) {
            return pid + ",";
        } else {
            pid = ((SysDictData)this.sysDictDataService.getById(pid)).getParentIds();
            pids = pid + pids + ",";
            return pids;
        }
    }
}
