package com.testor.module.train.exam.model.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;


/**
 * 题库——安全培训教育对象 t_train_question_bank
 *
 * @author testor-framework
 * @date 2022-07-13 15:19:22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_train_question_bank")
@ApiModel(value = "TTrainQuestionBank对象", description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TTrainQuestionBank extends SuperModel {
    private static final long serialVersionUID = 1L;
    /**
     * 主键ID
     */
    @ApiModelProperty(value = "主键ID")

    @TableId("id")
    private String id;
    /**
     * 题库名称
     */
    @ApiModelProperty(value = "题库名称")

    @TableField("question_bank_name")
    private String questionBankName;
    /**
     * 题库状态（开启 关闭）
     */
    @ApiModelProperty(value = "题库状态（1 开启 0 关闭）")

    @TableField("question_bank_status")
    private String questionBankStatus;
    /**
     * 题库来源
     */
    @ApiModelProperty(value = "题库来源")

    @TableField("question_bank_source")
    private String questionBankSource;
    /**
     * 流程状态
     */
    @ApiModelProperty(value = "流程状态")

    @TableField("process_status")
    private String processStatus;
    /**
     * 父级ID
     */
    @ApiModelProperty(value = "父级ID")

    @TableField("parent_id")
    private String parentId;
    /**
     * 租户id
     */
    @ApiModelProperty(value = "租户id")

    @TableField("tenant_id")
    private String tenantId;
    /**
     * 流程实例ID
     */
    @ApiModelProperty(value = "流程实例ID")

    @TableField("process_id")
    private String processId;

    /**
     * 组织机构id
     */
    @ApiModelProperty(value = "组织机构id")

    @TableField("org_id")
    private String orgId;

    public static final String ID = "id";
    public static final String QUESTION_BANK_NAME = "question_bank_name";
    public static final String QUESTION_BANK_STATUS = "question_bank_status";
    public static final String QUESTION_BANK_SOURCE = "question_bank_source";
    public static final String PROCESS_STATUS = "process_status";
    public static final String PARENT_ID = "parent_id";
    public static final String TENANT_ID = "tenant_id";
    public static final String PROCESS_ID = "process_id";
    public static final String ORG_ID = "org_id";


}
