package com.testor.module.train.project.model.dto;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.testor.module.train.course.model.domain.TTrainCourse;
import com.testor.module.train.project.model.domain.TTrainProject;
import com.testor.module.train.project.model.stat.ProjectErrorQuesVo;
import com.testor.module.train.project.model.stat.ProjectScoreStatVo;
import com.testor.module.train.project.model.stat.ProjectStatTotalVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 教育培训计划—安全培训教育 删除参数对象
 *
 * @author testor-framework
 * @date 2022-07-28 15:15:20
 */

@Data
@ApiModel(value = "TTrainProject 列表查询参数对象")
@EqualsAndHashCode(callSuper = true)
public class TTrainProjectParam extends TTrainProject {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "每页数量")
    private String limit;

    @ApiModelProperty(value = "当前页数")
    private String page;

    @ApiModelProperty(value = "排序字段")
    private String orderBy;

    @ApiModelProperty(value = "排序方式")
    private String orderType;

    @ApiModelProperty(value = "人员id")
    private String personId;

    @ApiModelProperty(value = "对象id")
    private String myManagementId;

    @ApiModelProperty(value = "参训对象")
    private List<MyManagement> myManagements;

    @ApiModelProperty(value = "计划关联课程")
    private List<TTrainCourse> trainCourses;

    @ApiModelProperty(value = "参训方")
    private String personAffiliation;

    @ApiModelProperty(value = "参训单位")
    private String company;

    @ApiModelProperty(value = "试卷名称")
    private String testPaperName;

    private String StartTime;

    private String EndTime;

    private String tabStatus;

    @ApiModelProperty(value = "评价人数")
    private String evaluationPerson;

    @ApiModelProperty(value = "评价平均分")
    private String evaluationAvg;



    @ApiModelProperty(value = "错题排行")
    private List<ProjectErrorQuesVo> wrongQuestionRanking;
    @ApiModelProperty(value = "考试得分统计")
    private ProjectScoreStatVo scoreStatByProjectId;




}
