package com.testor.module.train.project.model.enums;

/**
 *
 * @author
 * @date 2024/9/6
 * @description  tab切换，1 课程 2 考试 3 练习
 */
public enum TrainTabStatus {

    /**
     *     教育培训_培训类型(train_type)
     *         新员工及转岗培训 4
     *         实操培训 3
     *         专项培训 2
     *         综合培训  1
     */
    A_M("1", "课程"),
    B_M("2", "考试"),
    C_M("3", "练习"),

    ;
    private String value;
    private String name;

    TrainTabStatus(String value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getValue() {
        return value;
    }

    public String getName() {
        return name;
    }

    public static String getName(String value) {
        for (TrainTabStatus bean : TrainTabStatus.values()) {
            if (bean.getValue().equals(value)) {
                return bean.getName();
            }
        }
        return value;
    }
}
