package com.testor.module.video.controller;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

import com.testor.biz.sys.org.model.domain.SysOrg;
import com.testor.biz.sys.org.service.SysOrgService;
import com.testor.module.video.service.VideoDeviceNumberService;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.exception.BusinessException;
import com.tongtech.tfw.backend.common.models.sys.UserInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperController;


@RestController
@RequestMapping("/module/number")
@Api(value = "VideoDeviceNumber", tags = "视频监控设备信息和粮库对应")
@Slf4j
public class VideoDeviceNumberController extends SuperController {
    @Autowired
    private VideoDeviceNumberService videoDeviceNumberService;

	@Autowired
	private SysOrgService sysOrgService;

	//根据登录用户粮库信息获取设备编号列表
	@ApiOperation(value = "根据登录用户粮库信息获取设备编号列表", notes = "Add VideoDeviceNumber")
	@GetMapping(value = "/list")
	public BaseResponse<List<String>> list() throws BusinessException {
		UserInfo loginUser = ContextUtils.getLoginUser();
		//判断登录用户属于组织的那一集别
		String loginOrgId = loginUser.getOrgId();
		SysOrg orgInfo= sysOrgService.getById(loginOrgId);
		String childrenOrgId;
		if (orgInfo != null) {
			BigDecimal treeLevel = orgInfo.getTreeLevel();
			int flag = treeLevel.compareTo(BigDecimal.valueOf(3));
			if (flag == 1) {
				//粮库下面的分部门，通过parneids里面获取粮库id
				String[] split =orgInfo.getParentIds().split(",");
				childrenOrgId = split[2];
			} else {
				childrenOrgId = loginOrgId;
			}
		}else{
			throw new BusinessException("登录用户数据异常");
		}
		List<String> list= new ArrayList<>();
		list = videoDeviceNumberService.getDeviceIdByOrgId(childrenOrgId);
		BaseResponse<List<String>> result= new BaseResponse<>();
		result.setData(list);
		return result;
	}

}
