/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.springboot.reactive;

import com.tongweb.container.startup.ServletContainer;
import com.tongweb.springboot.starter.TongWebConnectorCustomizer;
import com.tongweb.springboot.starter.TongWebContextCustomizer;
import com.tongweb.springboot.starter.TongWebProtocolHandlerCustomizer;
import com.tongweb.springboot.starter.TongWebReactiveWebServerFactory;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.web.reactive.server.ReactiveWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

abstract class ReactiveTongWebWebServerFactoryConfiguration {
    ReactiveTongWebWebServerFactoryConfiguration() {
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={ReactiveWebServerFactory.class})
    @ConditionalOnClass(value={ServletContainer.class})
    static class EmbeddedTongWeb {
        EmbeddedTongWeb() {
        }

        @Bean
        @ConditionalOnMissingBean(value={ReactiveWebServerFactory.class})
        TongWebReactiveWebServerFactory tongWebReactiveWebServerFactory(ObjectProvider<TongWebConnectorCustomizer> connectorCustomizers, ObjectProvider<TongWebContextCustomizer> contextCustomizers, ObjectProvider<TongWebProtocolHandlerCustomizer<?>> protocolHandlerCustomizers) {
            TongWebReactiveWebServerFactory factory = new TongWebReactiveWebServerFactory();
            factory.getTongWebConnectorCustomizers().addAll(connectorCustomizers.orderedStream().collect(Collectors.toList()));
            factory.getTongWebContextCustomizers().addAll(contextCustomizers.orderedStream().collect(Collectors.toList()));
            factory.getTongWebProtocolHandlerCustomizers().addAll(protocolHandlerCustomizers.orderedStream().collect(Collectors.toList()));
            return factory;
        }

        @Bean
        TongWebReactiveWebServerFactory tongWebReactiveWebServerFactory() {
            return new TongWebReactiveWebServerFactory();
        }
    }
}

