/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tianfu.json.internal.sql;

import com.tongtech.tianfu.json.Json;
import com.tongtech.tianfu.json.TypeAdapter;
import com.tongtech.tianfu.json.TypeAdapterFactory;
import com.tongtech.tianfu.json.reflect.TypeToken;
import com.tongtech.tianfu.json.stream.JsonReader;
import com.tongtech.tianfu.json.stream.JsonWriter;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Date;

class SqlTimestampTypeAdapter
extends TypeAdapter<Timestamp> {
    static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Json json, TypeToken<T> typeToken) {
            if (typeToken.getRawType() == Timestamp.class) {
                TypeAdapter<Date> dateTypeAdapter = json.getAdapter(Date.class);
                return new SqlTimestampTypeAdapter(dateTypeAdapter);
            }
            return null;
        }
    };
    private final TypeAdapter<Date> dateTypeAdapter;

    private SqlTimestampTypeAdapter(TypeAdapter<Date> dateTypeAdapter) {
        this.dateTypeAdapter = dateTypeAdapter;
    }

    @Override
    public Timestamp read(JsonReader in) throws IOException {
        Date date = this.dateTypeAdapter.read(in);
        return date != null ? new Timestamp(date.getTime()) : null;
    }

    @Override
    public void write(JsonWriter out, Timestamp value) throws IOException {
        this.dateTypeAdapter.write(out, value);
    }
}

