/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.common.security;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import org.flowable.idm.api.User;
import org.flowable.ui.common.model.RemoteUser;
import org.flowable.ui.common.security.FlowableAppUser;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class SecurityUtils {
    private static User assumeUser;

    private SecurityUtils() {
    }

    public static String getCurrentUserId() {
        User user = SecurityUtils.getCurrentUserObject();
        if (user != null) {
            return user.getId();
        }
        return null;
    }

    public static User getCurrentUserObject() {
        if (assumeUser != null) {
            return assumeUser;
        }
        System.out.println("******tfw-workflow getCurrentUserObject************");
        RemoteUser user = new RemoteUser();
        user.setId("admin");
        user.setDisplayName("Administrator");
        user.setFirstName("Administrator");
        user.setLastName("Administrator");
        user.setEmail("admin@flowable.com");
        user.setPassword("123456");
        ArrayList<String> pris = new ArrayList<String>();
        pris.add("access-modeler");
        pris.add("access-idm");
        pris.add("access-admin");
        pris.add("access-task");
        pris.add("access-rest-api");
        user.setPrivileges(pris);
        System.out.println("******tfw-workflow getCurrentUserObject user************" + JSON.toJSONString((Object)user));
        return user;
    }

    public static FlowableAppUser getCurrentFlowableAppUser() {
        Object principal;
        FlowableAppUser user = null;
        SecurityContext securityContext = SecurityContextHolder.getContext();
        if (securityContext != null && securityContext.getAuthentication() != null && (principal = securityContext.getAuthentication().getPrincipal()) instanceof FlowableAppUser) {
            user = (FlowableAppUser)principal;
        }
        return user;
    }

    public static boolean currentUserHasCapability(String capability) {
        FlowableAppUser user = SecurityUtils.getCurrentFlowableAppUser();
        for (GrantedAuthority grantedAuthority : user.getAuthorities()) {
            if (!capability.equals(grantedAuthority.getAuthority())) continue;
            return true;
        }
        return false;
    }

    public static void assumeUser(User user) {
        assumeUser = user;
    }

    public static void clearAssumeUser() {
        assumeUser = null;
    }
}

