/*
 * Decompiled with CFR 0.152.
 */
package com.testor.biz.sys.resource.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.testor.biz.sys.resource.ResourceEnumCode;
import com.testor.biz.sys.resource.model.domain.SysResource;
import com.testor.biz.sys.resource.model.dto.SysResourceCheckResponse;
import com.testor.biz.sys.resource.model.dto.SysResourceDelParam;
import com.testor.biz.sys.resource.model.dto.SysResourceParam;
import com.testor.biz.sys.resource.model.dto.SysResourceRequest;
import com.testor.biz.sys.resource.model.dto.SysResourceResponse;
import com.testor.biz.sys.resource.service.SysResourceService;
import com.testor.biz.sys.roleResource.model.domain.SysRoleResource;
import com.testor.biz.sys.roleResource.service.SysRoleResourceService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.constants.enumeration.BaseStatusEnum;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="SysResource", tags={"SysResource \u83dc\u5355\u8d44\u6e90\u7ba1\u7406"})
@RequestMapping(value={"/resource"})
public class SysResourceController
extends SuperController {
    private static final Logger log = LoggerFactory.getLogger(SysResourceController.class);
    @Autowired
    private SysResourceService sysResourceService;
    @Autowired
    private SysRoleResourceService sysRoleResourceService;

    @ApiOperation(value="\u65b0\u589e\u83dc\u5355\u8d44\u6e90", notes="\u65b0\u589e\u83dc\u5355\u8d44\u6e90 Add SysResource")
    @PostMapping(value={"/add"})
    public BaseResponse<SysResource> addEntity(@RequestBody SysResourceRequest addRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)addRequest)) {
            QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().ne((Object)"status", (Object)"1")).and(i -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)i.eq((Object)"resource_url", (Object)(StringHelper.isNotEmpty((CharSequence)addRequest.getResourceUrl()) ? addRequest.getResourceUrl() : "menu-url-999"))).or()).eq((Object)"permission", (Object)addRequest.getPermission())).or()).eq((Object)"router_mapping", (Object)addRequest.getRouterMapping());
            })).last("LIMIT 1");
            SysResource sysExistedResource = (SysResource)((Object)this.sysResourceService.getOne((Wrapper)queryWrapper));
            if (ObjectHelper.isNotEmpty((Object)((Object)sysExistedResource))) {
                if (addRequest.getResourceUrl().equals(sysExistedResource.getResourceUrl()) && addRequest.getResourceType().equals(sysExistedResource.getResourceType())) {
                    throw new ApiException(ResourceEnumCode.EXISTED.transform());
                }
                if (addRequest.getPermission().equals(sysExistedResource.getPermission())) {
                    throw new ApiException(ResourceEnumCode.PERMISSION_EXISTED.transform());
                }
            }
            if (StringHelper.isEmpty((CharSequence)addRequest.getParentId())) {
                addRequest.setParentId("0");
            }
            addRequest.setParentIds(this.queryParentsIds(addRequest.getParentId()));
            SysResource data = (SysResource)((Object)BeanHelper.beanToBean((Object)addRequest, SysResource.class));
            data.setResourceId(IdHelper.getId32bit());
            boolean result = this.sysResourceService.save((Object)data);
            if (result) {
                baseResponse.setData((Object)data);
            }
        }
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6\u83dc\u5355\u8d44\u6e90\u8be6\u7ec6\u4fe1\u606f", notes="\u83b7\u53d6\u83dc\u5355\u8d44\u6e90\u8be6\u7ec6\u4fe1\u606f Get Resource By id")
    @GetMapping(value={"/get"})
    public BaseResponse<SysResource> getById(String resourceId) {
        BaseResponse baseResponse = new BaseResponse();
        if (StringHelper.isNotEmpty((CharSequence)resourceId)) {
            SysResource data = (SysResource)((Object)this.sysResourceService.getById((Serializable)((Object)resourceId)));
            if (ObjectHelper.isEmpty((Object)((Object)data))) {
                throw new ApiException(ResourceEnumCode.RESOURCE_ID_NOT_EXISTED.transform());
            }
            baseResponse.setData((Object)data);
        }
        return baseResponse;
    }

    @ApiOperation(value="\u4fee\u6539\u83dc\u5355\u8d44\u6e90", notes="\u4fee\u6539\u83dc\u5355\u8d44\u6e90 Update SysResource by Id")
    @PutMapping(value={"/update"})
    public BaseResponse<SysResource> updateEntity(@RequestBody SysResourceRequest updateRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)updateRequest) && StringHelper.isNotEmpty((CharSequence)updateRequest.getResourceId())) {
            boolean result;
            SysResource data = (SysResource)((Object)BeanHelper.beanToBean((Object)updateRequest, SysResource.class));
            QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().ne((Object)"status", (Object)"1")).ne((Object)"resource_id", (Object)updateRequest.getResourceId())).and(i -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)i.eq((Object)"resource_url", (Object)(StringHelper.isNotEmpty((CharSequence)updateRequest.getResourceUrl()) ? updateRequest.getResourceUrl() : "menu-url-999"))).or()).eq((Object)"permission", (Object)updateRequest.getPermission())).or()).eq((Object)"router_mapping", (Object)updateRequest.getRouterMapping());
            })).last("LIMIT 1");
            SysResource sysExistedResource = (SysResource)((Object)this.sysResourceService.getOne((Wrapper)queryWrapper));
            if (ObjectHelper.isNotEmpty((Object)((Object)sysExistedResource))) {
                if (updateRequest.getResourceUrl().equals(sysExistedResource.getResourceUrl()) && updateRequest.getResourceType().equals(sysExistedResource.getResourceType())) {
                    throw new ApiException(ResourceEnumCode.EXISTED.transform());
                }
                if (updateRequest.getPermission().equals(sysExistedResource.getPermission())) {
                    throw new ApiException(ResourceEnumCode.PERMISSION_EXISTED.transform());
                }
            }
            SysResource oldData = (SysResource)((Object)this.sysResourceService.getById((Serializable)((Object)updateRequest.getResourceId())));
            if (StringHelper.isNotEmpty((CharSequence)updateRequest.getParentId()) && !oldData.getParentId().equals(updateRequest.getParentId())) {
                String newParentIds = this.queryParentsIds(updateRequest.getParentId());
                data.setParentIds(newParentIds);
                List<SysResource> subResourceTree = this.getAllSub(updateRequest.getResourceId());
                for (SysResource resourceTree : subResourceTree) {
                    String newIds = this.replaceParentIds(resourceTree.getParentIds(), newParentIds, updateRequest.getResourceId());
                    if (StringHelper.isNotEmpty((CharSequence)newIds)) {
                        resourceTree.setParentIds(newIds);
                        continue;
                    }
                    log.error("TTestTree Parents Id update Failed:" + updateRequest.getParentId() + ", related sub : " + resourceTree.getResourceId());
                }
                boolean batchResult = this.sysResourceService.updateBatchById(subResourceTree);
                if (subResourceTree.size() > 0 && !batchResult) {
                    throw new ApiException(BaseStatusEnum.RELATE_UPDATE_FAILED.transform());
                }
            }
            if (StringHelper.isNotEmpty((CharSequence)updateRequest.getStatus()) && !oldData.getStatus().equals(updateRequest.getStatus())) {
                List parentResourceList = this.sysResourceService.list((Wrapper)new QueryWrapper().lambda().like(SysResource::getParentIds, (Object)data.getResourceId()));
                this.sysResourceService.updateBatchById(parentResourceList.stream().peek(resource -> resource.setStatus(updateRequest.getStatus())).collect(Collectors.toList()));
            }
            if (result = this.sysResourceService.updateById((Object)data)) {
                baseResponse.setData((Object)data);
            }
        }
        return baseResponse;
    }

    @ApiOperation(value="\u5220\u9664\u83dc\u5355\u8d44\u6e90", notes="\u5220\u9664\u83dc\u5355\u8d44\u6e90 Delete SysResource by Id")
    @PutMapping(value={"/delete"})
    public BaseResponse<SysResourceResponse> delEntity(@RequestBody SysResourceDelParam resourceId) {
        BaseResponse baseResponse = new BaseResponse();
        if (StringHelper.isNotEmpty((CharSequence)resourceId.getResourceId())) {
            SysResource existed = (SysResource)((Object)this.sysResourceService.getById((Serializable)((Object)resourceId.getResourceId())));
            if (ObjectHelper.isEmpty((Object)((Object)existed))) {
                throw new ApiException(ResourceEnumCode.RESOURCE_ID_NOT_EXISTED.transform());
            }
            existed = new SysResource();
            existed.setResourceId(resourceId.getResourceId());
            existed.setStatus("1");
            List parentResourceList = this.sysResourceService.list((Wrapper)new QueryWrapper().lambda().like(SysResource::getParentIds, (Object)existed.getResourceId()));
            this.sysResourceService.updateBatchById(parentResourceList.stream().peek(resource -> resource.setStatus("1")).collect(Collectors.toList()));
            List ids = parentResourceList.stream().map(SysResource::getResourceId).collect(Collectors.toList());
            ids.add(resourceId.getResourceId());
            this.sysRoleResourceService.remove((Wrapper)new QueryWrapper().lambda().in(SysRoleResource::getResourceId, ids));
            boolean result = this.sysResourceService.updateById((Object)existed);
            baseResponse.setData((Object)SysResourceResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6\u83dc\u5355\u8d44\u6e90\u5217\u8868", notes="\u83b7\u53d6\u83dc\u5355\u8d44\u6e90\u5217\u8868 List Resources")
    @GetMapping(value={"/list"})
    public BaseResponse<BaseResponseList<SysResource>> listAllEntity(SysResourceParam param) {
        BaseResponse baseResponse = new BaseResponse();
        QueryWrapper<SysResource> queryWrapper = this.createQuery(param);
        List resultList = this.sysResourceService.list((Wrapper)queryWrapper);
        if (ObjectHelper.isEmpty((Object)resultList)) {
            throw new ApiException(ResourceEnumCode.RESOURCE_ID_NOT_EXISTED.transform());
        }
        BaseResponseList baseResponseList = new BaseResponseList();
        baseResponseList.setData(resultList);
        baseResponseList.setTotal(resultList.size() + "");
        baseResponse.setData((Object)baseResponseList);
        return baseResponse;
    }

    @ApiOperation(value="\u83dc\u5355\u8d44\u6e90\u6743\u9650\u6807\u8bc6\u552f\u4e00\u6027\u68c0\u67e5", notes="\u83dc\u5355\u8d44\u6e90\u6743\u9650\u6807\u8bc6\u552f\u4e00\u6027\u68c0\u67e5 /permission/unique_checks")
    @GetMapping(value={"/permission/unique_checks"})
    public BaseResponse<SysResourceCheckResponse> permissionUniqueChecks(String permission) {
        BaseResponse baseResponse = new BaseResponse();
        ArrayList<String> ids = new ArrayList<String>();
        QueryWrapper queryWrapper = new QueryWrapper();
        SysResourceCheckResponse sysResourceCheckResponse = SysResourceCheckResponse.builder().resourceIds(ids).build();
        queryWrapper.eq((Object)"permission", (Object)permission);
        List sysExistedResource = this.sysResourceService.list((Wrapper)queryWrapper);
        if (ObjectHelper.isNotEmpty((Object)sysExistedResource)) {
            for (SysResource sysResource : sysExistedResource) {
                ids.add(sysResource.getResourceId());
            }
            sysResourceCheckResponse.setResourceIds(ids);
        }
        baseResponse.setData((Object)sysResourceCheckResponse);
        return baseResponse;
    }

    @ApiOperation(value="\u83dc\u5355\u8d44\u6e90\u8def\u7531\u6620\u5c04\u540d\u79f0\u552f\u4e00\u6027\u68c0\u67e5", notes="\u83dc\u5355\u8d44\u6e90\u8def\u7531\u6620\u5c04\u540d\u79f0\u552f\u4e00\u6027\u68c0\u67e5 /router/unique_checks")
    @GetMapping(value={"/router/unique_checks"})
    public BaseResponse<SysResourceCheckResponse> routerUniqueChecks(String routerMapping) {
        BaseResponse baseResponse = new BaseResponse();
        ArrayList<String> ids = new ArrayList<String>();
        QueryWrapper queryWrapper = new QueryWrapper();
        SysResourceCheckResponse sysResourceCheckResponse = SysResourceCheckResponse.builder().resourceIds(ids).build();
        queryWrapper.eq((Object)"router_mapping", (Object)routerMapping);
        List sysExistedResource = this.sysResourceService.list((Wrapper)queryWrapper);
        if (ObjectHelper.isNotEmpty((Object)sysExistedResource)) {
            for (SysResource sysResource : sysExistedResource) {
                ids.add(sysResource.getResourceId());
            }
            sysResourceCheckResponse.setResourceIds(ids);
        }
        baseResponse.setData((Object)sysResourceCheckResponse);
        return baseResponse;
    }

    @ApiOperation(value="\u6839\u636e\u89d2\u8272ID\u83b7\u53d6\u83dc\u5355\u8d44\u6e90\u5217\u8868", notes="\u6839\u636e\u89d2\u8272ID\u83b7\u53d6\u83dc\u5355\u8d44\u6e90\u5217\u8868 /list_by_role")
    @GetMapping(value={"/list_by_role"})
    public BaseResponse<BaseResponseList<SysResource>> listByRole(String roleId) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)roleId)) {
            List<SysResource> sysResourceList = this.sysResourceService.loadRoleResource(roleId);
            BaseResponseList baseResponseList = new BaseResponseList();
            baseResponseList.setData(sysResourceList);
            baseResponseList.setTotal(sysResourceList.size() + "");
            baseResponse.setData((Object)baseResponseList);
        }
        return baseResponse;
    }

    private QueryWrapper<SysResource> createQuery(SysResourceParam queryParam) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getResourceId())) {
            queryWrapper.like((Object)"parent_ids", (Object)queryParam.getResourceId());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getStatus())) {
            queryWrapper.eq((Object)"status", (Object)queryParam.getStatus());
        } else {
            queryWrapper.ne((Object)"status", (Object)"1");
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getOrderBy())) {
            if (StringHelper.isNotEmpty((CharSequence)queryParam.getOrderType()) && "asc".equals(queryParam.getOrderType())) {
                queryWrapper.orderByAsc((Object)queryParam.getOrderBy());
            } else {
                queryWrapper.orderByDesc((Object)queryParam.getOrderBy());
            }
        } else {
            queryWrapper.orderByAsc((Object)"resource_sort");
        }
        return queryWrapper;
    }

    private String queryParentsIds(String pid) {
        String pids = pid;
        if ("0".equals(pid)) {
            return pids + ",";
        }
        pid = ((SysResource)((Object)this.sysResourceService.getById((Serializable)((Object)pid)))).getParentIds();
        pids = pid + pids + ",";
        return pids;
    }

    private List<SysResource> getAllSub(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.like((Object)"parent_ids", (Object)id);
        return this.sysResourceService.list((Wrapper)queryWrapper);
    }

    private String replaceParentIds(String oldIds, String newIds, String id) {
        String[] splited = oldIds.split("," + id + ",");
        newIds = splited.length == BizConstants.PARENTS_ID_SPLIT_END ? newIds + id + "," : (splited.length == BizConstants.PARENTS_ID_SPLIT_LENGTH ? newIds + id + "," + splited[1] : "");
        return newIds;
    }
}

