package com.testor.config;

import com.testor.biz.sys.log.service.impl.NewSysLogServiceImpl;
import com.testor.biz.sys.org.service.SysOrgService;
import com.testor.biz.sys.resource.service.SysResourceService;
import com.testor.biz.sys.user.service.SysUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.context.annotation.Bean;

/**
 * LoggerConfig
 *
 * @author ivan
 * @version 1.0 Created by ivan at 1/22/21.
 */
@SpringBootConfiguration
public class LoggerConfig {
    @Autowired
    SysUserService sysUserService;
    @Autowired
    SysOrgService sysOrgService;
    @Autowired
    SysResourceService sysResourceService;

    @Bean("LogService")
    public NewSysLogServiceImpl getLogger() {
        return new NewSysLogServiceImpl(sysUserService, sysOrgService, sysResourceService);
    }
}
