package com.testor.ddd.safetyControl.infrastructure.repository.equipment.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.Date;


/**
 * 空间设备对象 t_safe_equipment
 * 
 * @author testor-framework
 * @date 2022-06-27 16:56:19
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_safe_equipment")
@ApiModel(value = "TSafeEquipment对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TSafeEquipmentDO extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * id
 */
  @ApiModelProperty(value = "id")
  @TableId(value="id", type = IdType.ASSIGN_UUID)
  private String id;
/**
 * 组织机构id
 */
  @ApiModelProperty(value = "组织机构id")
  @TableField("org_id")
  private String orgId;

  @TableField("sys_type_id")
  private String sysTypeId;

  @TableField("equipment_type_id")
  private String equipmentTypeId;

  @TableField("name")
  private String name;
/**
 * 编码
 */
  @ApiModelProperty(value = "编码")

  @TableField("code")
  private String code;
/**
 * 规格型号
 */
  @ApiModelProperty(value = "规格型号")

  @TableField("specification")
  private String specification;

  /**
   * 照片路径
   */
  @ApiModelProperty(value = "照片路径")
  @TableField("img_url")
  private String imgUrl;

/**
 * 车间场所id(space表 level=1)
 */
  @ApiModelProperty(value = "车间场所id(space表 level=1)")

  @TableField("space_id")
  private String spaceId;
/**
 * 作业区域id(space表 level=2)
 */
  @ApiModelProperty(value = "作业区域id(space表 level=2)")

  @TableField("space_area_id")
  private String spaceAreaId;
/**
 * 生产厂商
 */
  @ApiModelProperty(value = "生产厂商")

  @TableField("manufacturer")
  private String manufacturer;
/**
 * 描述
 */
  @ApiModelProperty(value = "描述")

  @TableField("des")
  private String des;

  @TableField("validity_date")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date validityDate;

  @TableField("is_special")
  private String isSpecial;

  public static final String ID ="id";
  public static final String ORG_ID ="org_id";
  public static final String SYS_TYPE_ID ="sys_type_id";
  public static final String EQUIPMENT_TYPE_ID ="equipment_type_id";
  public static final String NAME ="name";
  public static final String CODE ="code";
  public static final String SPECIFICATION ="specification";
  public static final String SPACE_ID ="space_id";
  public static final String SPACE_AREA_ID ="space_area_id";
  public static final String MANUFACTURER ="manufacturer";
  public static final String DES ="des";
  public static final String VALIDITY_DATE ="validity_date";
  public static final String IS_SPECIAL ="is_special";


}
