package com.testor.module.contractor.common.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import com.testor.module.contractor.common.model.domain.TContractorLedgerProject;

/**
 * 承包商台账和项目台账关系 删除参数对象
 *
 * @author testor-framework
 * @date 2024-11-20 20:50:55
 */

@Data
@ApiModel(value = "TContractorLedgerProject 列表查询参数对象")
@EqualsAndHashCode(callSuper = true)
public class TContractorLedgerProjectParam extends TContractorLedgerProject {
	private static final long serialVersionUID = 1L;
	@ApiModelProperty(value = "每页数量")
	private String limit;

	@ApiModelProperty(value = "当前页数")
	private String page;

	@ApiModelProperty(value = "排序字段")
	private String orderBy;

	@ApiModelProperty(value = "排序方式")
	private String orderType;

}
