package com.testor.module.fives.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.fives.model.domain.TFivesToolCase;
import com.testor.module.fives.model.dto.TFivesToolCaseDelParam;
import com.testor.module.fives.model.dto.TFivesToolCaseParam;
import com.testor.module.fives.service.TFivesToolCaseService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * 5s工具运用改善案例Controller
 *
 * @author testor-framework
 * @date 2022-07-21 15:56:52
 */
@RestController
@RequestMapping("/module/fives/tool/case")
@Api(value = "TFivesToolCase", tags = "5s工具运用改善案例")
@Slf4j
public class TFivesToolCaseController extends SuperController {
    @Autowired
    private TFivesToolCaseService tFivesToolCaseService;

    /* Generated Method*/
    @ApiOperation(value = "新增 5s工具运用改善案例", notes = "Add TFivesToolCase")
    @PostMapping(value = "/add")
    public BaseResponse<TFivesToolCase> addEntity(@RequestBody TFivesToolCase addRequest) {
        BaseResponse<TFivesToolCase> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(addRequest)) {
            // TODO 按需求添加数据去重，特殊值设定，业务异常
            String id = IdHelper.getId32bit();
            TFivesToolCase data = BeanHelper.beanToBean(addRequest, TFivesToolCase.class);
            data.setId(id);
            boolean result = tFivesToolCaseService.save(data);
            if (result) {
                TFivesToolCase newEntity = new TFivesToolCase();
                newEntity.setId(id);
                baseResponse.setData(newEntity);
            }
        }
        return baseResponse;
    }

    @ApiOperation(value = "获取 5s工具运用改善案例 ", notes = "Get TFivesToolCase By Id")
    @GetMapping(value = "/get")
    public BaseResponse<TFivesToolCase> getById(String id) {
        BaseResponse<TFivesToolCase> baseResponse = new BaseResponse<>();
        if (StringHelper.isNotEmpty(id)) {
            // TODO 按需求添加业务异常判断
            TFivesToolCase data = tFivesToolCaseService.getById(id);
            baseResponse.setData(data);
        }
        return baseResponse;
    }

    @ApiOperation(value = "修改 5s工具运用改善案例 ", notes = "Update TFivesToolCase By Id")
    @PutMapping(value = "/update")
    public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TFivesToolCase updateRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(updateRequest) && StringHelper.isNotEmpty(updateRequest.getId())) {
            // TODO 按需求添加数据去重，特殊值设定，业务异常
            TFivesToolCase data = BeanHelper.beanToBean(updateRequest, TFivesToolCase.class);
            boolean result = tFivesToolCaseService.updateById(data);
            baseResponse.setData(
                    BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value = "删除 5s工具运用改善案例 ", notes = "delete TFivesToolCase By Id")
    @PutMapping(value = "/delete")
    public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TFivesToolCaseDelParam deleteRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(deleteRequest) && StringHelper.isNotEmpty(deleteRequest.getId())) {
            // TODO 按需求添加数据去重，特殊值设定，业务异常
            TFivesToolCase data = new TFivesToolCase();
            data.setId(deleteRequest.getId());
            data.setStatus(BizConstants.STATUS_DELETE);
            boolean result = tFivesToolCaseService.updateById(data);
            baseResponse.setData(
                    BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value = "批量删除5s工具运用改善案例", notes = "delete TFivesToolCase by batch Id")
    @PutMapping(value = "/batch_delete")
    public BaseResponse<BizGeneralResponse> deleteEntityBatch(
            @RequestBody TFivesToolCaseDelParam deleteRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
            List<TFivesToolCase> tFivesToolCaseList = new ArrayList<>();
            for (String id : deleteRequest.getIds()) {
                TFivesToolCase data = new TFivesToolCase();
                data.setId(id);
                data.setStatus(BizConstants.STATUS_DELETE);
                tFivesToolCaseList.add(data);
            }
            boolean result = tFivesToolCaseService.updateBatchById(tFivesToolCaseList);
            baseResponse.setData(
                    BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value = "获取 5s工具运用改善案例 分页列表", notes = "List TFivesToolCase with page")
    @GetMapping(value = "/list")
    public BaseResponse<BaseResponseList<TFivesToolCase>> listEntity(TFivesToolCaseParam param) {
        BaseResponse<BaseResponseList<TFivesToolCase>> baseResponse = new BaseResponse<>();
        Long page =
                StringHelper.isEmpty(param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit =
                StringHelper.isEmpty(param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page<TFivesToolCase> resultPage = new Page<>(page, limit);
        // TODO 根据需求修改查询条件及查询参数
        QueryWrapper<TFivesToolCase> queryWrapper = this.createQuery(param);
        Page<TFivesToolCase> resultList = tFivesToolCaseService.page(resultPage, queryWrapper);
        BaseResponseList<TFivesToolCase> baseResponseList = new BaseResponseList<>();
        baseResponseList.setData(resultList.getRecords());
        baseResponseList.setTotal(resultList.getTotal());
        baseResponse.setData(baseResponseList);
        return baseResponse;
    }

    @ApiOperation(value = "获取 5s工具运用改善案例 列表", notes = "List TFivesToolCase all")
    @GetMapping(value = "/datas")
    public BaseResponse<BaseResponseList<TFivesToolCase>> listAllEntity(TFivesToolCaseParam param) {
        BaseResponse<BaseResponseList<TFivesToolCase>> baseResponse = new BaseResponse<>();
        // TODO 根据需求修改查询条件及查询参数
        QueryWrapper<TFivesToolCase> queryWrapper = this.createQuery(param);
        List<TFivesToolCase> resultList = tFivesToolCaseService.list(queryWrapper);
        BaseResponseList<TFivesToolCase> baseResponseList = new BaseResponseList<>();
        baseResponseList.setData(resultList);
        baseResponseList.setTotal(resultList.size());
        baseResponse.setData(baseResponseList);
        return baseResponse;
    }

    /* Private Methods */

    /**
     * 列表查询条件及查询参数
     */
    private QueryWrapper<TFivesToolCase> createQuery(TFivesToolCaseParam queryParam) {
        QueryWrapper<TFivesToolCase> queryWrapper = new QueryWrapper<>();
        if (StringHelper.isNotEmpty(queryParam.getRefId())) {
            queryWrapper.eq(TFivesToolCase.REF_ID, queryParam.getRefId());
        }
        if (StringHelper.isNotEmpty(queryParam.getParentId())) {
            queryWrapper.eq(TFivesToolCase.PARENT_ID, queryParam.getParentId());
        }
        if (StringHelper.isNotEmpty(queryParam.getTenantId())) {
            queryWrapper.eq(TFivesToolCase.TENANT_ID, queryParam.getTenantId());
        }
        if (StringHelper.isNotEmpty(queryParam.getProcessId())) {
            queryWrapper.eq(TFivesToolCase.PROCESS_ID, queryParam.getProcessId());
        }
        if (StringHelper.isNotEmpty(queryParam.getProcessStatus())) {
            queryWrapper.eq(TFivesToolCase.PROCESS_STATUS, queryParam.getProcessStatus());
        }
        if (StringHelper.isNotEmpty(queryParam.getCaseType())) {
            queryWrapper.eq(TFivesToolCase.CASE_TYPE, queryParam.getCaseType());
        }
        if (StringHelper.isNotEmpty(queryParam.getCaseName())) {
            queryWrapper.like(TFivesToolCase.CASE_NAME, queryParam.getCaseName());
        }
        if (StringHelper.isNotEmpty(queryParam.getRecommendReason())) {
            queryWrapper.eq(TFivesToolCase.RECOMMEND_REASON, queryParam.getRecommendReason());
        }
        if (StringHelper.isNotEmpty(queryParam.getProblemDes())) {
            queryWrapper.eq(TFivesToolCase.PROBLEM_DES, queryParam.getProblemDes());
        }
        if (StringHelper.isNotEmpty(queryParam.getImproveDes())) {
            queryWrapper.eq(TFivesToolCase.IMPROVE_DES, queryParam.getImproveDes());
        }
        if (StringHelper.isNotEmpty(queryParam.getImage1())) {
            queryWrapper.eq(TFivesToolCase.IMAGE_1, queryParam.getImage1());
        }
        if (StringHelper.isNotEmpty(queryParam.getImage2())) {
            queryWrapper.eq(TFivesToolCase.IMAGE_2, queryParam.getImage2());
        }
        if (StringHelper.isNotEmpty(queryParam.getStatus())) {
            queryWrapper.eq(TFivesToolCase.STATUS, queryParam.getStatus());
        } else {
            queryWrapper.ne(TFivesToolCase.STATUS, BizConstants.STATUS_DELETE);
        }
        if (StringHelper.isNotEmpty(queryParam.getOrderBy())) {
            if (StringHelper.isNotEmpty(queryParam.getOrderType())
                    && BizConstants.ASC.equals(queryParam.getOrderType())) {
                queryWrapper.orderByAsc(queryParam.getOrderBy());
            } else {
                queryWrapper.orderByDesc(queryParam.getOrderBy());
            }
        } else {
            queryWrapper.orderByDesc(TFivesToolCase.UPDATE_DATE);
        }
        return queryWrapper;
    }
}
