package com.testor.module.hazard.service.impl;

import com.testor.biz.sys.dict.data.model.domain.SysDictData;
import com.testor.biz.sys.dict.data.service.SysDictDataService;
import com.testor.common.constant.NoticeConstant;
import com.testor.common.constant.RemindConstants;
import com.testor.common.util.JsonUtils;
import com.testor.module.hazard.model.domain.THazardWorkPlan;
import com.testor.module.hazard.model.dto.THazardWorkPlanDTO;
import com.testor.module.hazard.model.enums.WorkPlanStatusEnum;
import com.testor.module.hazard.service.THazardWorkPlanService;
import com.testor.module.hazard.service.TimeoutRemindStrategy;
import com.testor.module.messageNotice.model.domain.TMsgNotice;
import com.testor.module.messageNotice.model.vo.MsgTemplateVO;
import com.testor.module.messageNotice.service.TMsgNoticeService;
import com.testor.module.sys.service.NewSysDictDataService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;

@Component(RemindConstants.REMIND_TYPE_OVER)
public class TimeoutStrategy extends BaseReminderStrategy implements TimeoutRemindStrategy {

    @Autowired
    private TMsgNoticeService tMsgNoticeService;
    @Autowired
    private THazardWorkPlanService tHazardWorkPlanService;

    @Override
    public void remind(String id) {
        THazardWorkPlan tHazardWorkPlan = tHazardWorkPlanService.getById(id);
        if (tHazardWorkPlan != null){
            String workStatus = tHazardWorkPlan.getWorkStatus();
            if (!workStatus.equals(WorkPlanStatusEnum.CLOSED.getValue()) || !workStatus.equals(WorkPlanStatusEnum.CANCELED.getValue())){
                List<TMsgNotice> sendNotice = sendNotice(tHazardWorkPlan, "作业超时", "已超时");
                tMsgNoticeService.saveBatch(sendNotice);
            }
        }
    }

}
