package com.testor.module.lease.model.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
public class HomeStatistics {

    @ApiModelProperty("机构id")
    private String orgId;

    @ApiModelProperty("机构名称")
    private String orgName;

    @ApiModelProperty("经度")
    private String longitude;

    @ApiModelProperty("维度")
    private String latitude;

    @ApiModelProperty("经营部数量")
    private int businessDeptNum;

    @ApiModelProperty(value = "自有粮库数量")
    private int fundsBankNum;

    @ApiModelProperty(value = "租赁库数量")
    private int tLeaseBankNUm;

    @ApiModelProperty(value = "粮库总数量")
    private int count ;

    @ApiModelProperty(value = "一般隐患")
    private int general;

    @ApiModelProperty(value = "重大隐患")
    private int greate;

    @ApiModelProperty(value = "隐患总数")
    private int hiddenDangerCount;

    @ApiModelProperty(value = "危险源总数")
    private int riskRourceNum;

    @ApiModelProperty(value = "重大危险源")
    private int major;

    @ApiModelProperty(value = "风险点数量")
    private int riskPoint;
}
