package com.testor.module.sys.service.impl;

import com.testor.biz.file.model.domain.SysFile;
import com.testor.biz.file.service.SysFileService;
import com.testor.common.core.utils.StringUtils;
import com.testor.module.sys.service.NewSysFileService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Service
public class NewSysFileServiceImpl implements NewSysFileService {

    @Autowired
    private SysFileService sysFileService;

    @Override
    public String getFileUrlByIds(String fileIds) {
        if (StringUtils.isBlank(fileIds)) {
            return "";
        }
        return Arrays.stream(fileIds.split(","))
                .map(sysFileService::getById)
                .filter(Objects::nonNull)
                .map(SysFile::getFilePath)
                .collect(Collectors.joining(","));
    }
}
