package com.testor.module.threeframework.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;


/**
 * 三同时管理对象 t_three_time
 *
 * @author testor-framework
 * @date 2022-09-15 17:16:20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_three_time")
@ApiModel(value = "TThreeTime对象-建设项目安全管理", description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TThreeTime extends SuperModel {
    private static final long serialVersionUID = 1L;
    /**
     * 主键ID
     */
    @ApiModelProperty(value = "主键ID")

    @TableId("id")
    private String id;

    @TableField(exist = false)
    @ApiModelProperty(value = "建设单位名称")
    private String orgName;
    /**
     * 附件上传
     */
    @ApiModelProperty(value = "附件上传")

    @TableField("ref_id")
    private String refId;
    /**
     * 父级ID
     */
    @ApiModelProperty(value = "父级ID")

    @TableField("parent_id")
    private String parentId;
    /**
     * 租户id
     */
    @ApiModelProperty(value = "租户id")

    @TableField("tenant_id")
    private String tenantId;
    /**
     * 流程实例ID
     */
    @ApiModelProperty(value = "流程实例ID")

    @TableField("process_id")
    private String processId;
    /**
     * 流程状态
     */
    @ApiModelProperty(value = "流程状态")

    @TableField("process_status")
    private String processStatus;
    /**
     * 项目编号
     */
    @ApiModelProperty(value = "项目编号")

    @TableField("serial_number")
    private String serialNumber;
    /**
     * 建设单位
     */
    @ApiModelProperty(value = "建设单位")

    @TableField("org_id")
    private String orgId;
    /**
     * 项目性质（字典配置）
     */
    @ApiModelProperty(value = "项目性质（字典配置）")

    @TableField("project_nature")
    private String projectNature;
    /**
     * 项目名称
     */
    @ApiModelProperty(value = "项目名称")

    @TableField("name")
    private String name;
    /**
     * 立项时间
     */
    @ApiModelProperty(value = "立项时间")

    @TableField("project_approval_date")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date projectApprovalDate;
    /**
     * 项目进度（1-可研/2-初设/3-施工/4-验收/5-后评价）
     */
    @ApiModelProperty(value = "项目进度（1-可研/2-初设/3-施工/4-验收/5-后评价/6-已完成）")

    @TableField("plan")
    private String plan;
    /**
     * 项目简介
     */
    @ApiModelProperty(value = "项目简介")

    @TableField("intro")
    private String intro;
    /**
     * 安全（预）评价（1-完成/0-未完成）
     */
    @ApiModelProperty(value = "安全（预）评价（1-完成/0-未完成）")

    @TableField("safety_evaluation")
    private String safetyEvaluation;
    /**
     * 环境影响评价（1-完成/0-未完成）
     */
    @ApiModelProperty(value = "环境影响评价（1-完成/0-未完成）")

    @TableField("evl_appraisal")
    private String evlAppraisal;
    /**
     * 安全设施设计专篇（1-完成/0-未完成）
     */
    @ApiModelProperty(value = "安全设施设计专篇（1-完成/0-未完成）")

    @TableField("safety_facilities")
    private String safetyFacilities;
    /**
     * 环境保护设施设计专篇（1-完成/0-未完成）
     */
    @ApiModelProperty(value = "环境保护设施设计专篇（1-完成/0-未完成）")

    @TableField("evl_protection")
    private String evlProtection;
    /**
     * 施工基本信息（1-完成/0-未完成）
     */
    @ApiModelProperty(value = "施工基本信息（1-完成/0-未完成）")

    @TableField("construction")
    private String construction;
    /**
     * 安全验收评价（1-完成/0-未完成）
     */
    @ApiModelProperty(value = "安全验收评价（1-完成/0-未完成）")

    @TableField("safety_acceptance")
    private String safetyAcceptance;
    /**
     * 环保验收监测（调查）（1-完成/0-未完成）
     */
    @ApiModelProperty(value = "环保验收监测（调查）（1-完成/0-未完成）")

    @TableField("evl_survey")
    private String evlSurvey;
    /**
     * 后评价基本信息（1-完成/0-未完成）
     */
    @ApiModelProperty(value = "后评价基本信息（1-完成/0-未完成）")

    @TableField("post_evaluation")
    private String postEvaluation;


    @ApiModelProperty(value = "危重大工程 1-是 0-否")
    @TableField("dangerous_projects_state")
    private String dangerousProjectsState;




    public static final String ID = "id";
    public static final String REF_ID = "ref_id";
    public static final String PARENT_ID = "parent_id";
    public static final String TENANT_ID = "tenant_id";
    public static final String PROCESS_ID = "process_id";
    public static final String PROCESS_STATUS = "process_status";
    public static final String SERIAL_NUMBER = "serial_number";
    public static final String ORG_ID = "org_id";
    public static final String PROJECT_NATURE = "project_nature";
    public static final String NAME = "name";
    public static final String PROJECT_APPROVAL_DATE = "project_approval_date";
    public static final String PLAN = "plan";
    public static final String INTRO = "intro";
    public static final String SAFETY_EVALUATION = "safety_evaluation";
    public static final String EVL_APPRAISAL = "evl_appraisal";
    public static final String SAFETY_FACILITIES = "safety_facilities";
    public static final String EVL_PROTECTION = "evl_protection";
    public static final String CONSTRUCTION = "construction";
    public static final String SAFETY_ACCEPTANCE = "safety_acceptance";
    public static final String EVL_SURVEY = "evl_survey";
    public static final String POST_EVALUATION = "post_evaluation";





}
