package com.testor.module.train.database.model.dto;

import com.testor.module.train.database.model.domain.TTrainDatabase;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 培训资料管理——安全培训教育 删除参数对象
 *
 * @author testor-framework
 * @date 2022-07-12 10:01:27
 */

@Data
@ApiModel(value = "TTrainDatabase 列表查询参数对象")
@EqualsAndHashCode(callSuper = true)
public class TTrainDatabaseParam extends TTrainDatabase {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "每页数量")
    private String limit;

    @ApiModelProperty(value = "当前页数")
    private String page;

    @ApiModelProperty(value = "排序字段")
    private String orderBy;

    @ApiModelProperty(value = "排序方式")
    private String orderType;

    @ApiModelProperty(value = "开始时间")
    private String startDateTime;

    @ApiModelProperty(value = "结束时间")
    private String endDateTime;
    @ApiModelProperty(value = "文件名称")
    private String fileName;
    @ApiModelProperty(value = "文件路径")
    private String filePath;


}
