package com.testor.module.train.myManagement.model.dto;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.testor.module.train.myManagement.model.domain.TTrainMyManagement;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.Date;

/**
 * 我的培训教育及考试—安全培训教育 删除参数对象
 *
 * @author testor-framework
 * @date 2022-07-28 15:25:02
 */

@Data
@ApiModel(value = "TTrainMyManagement 列表查询参数对象")
public class TrainMyManagementStatVo   {
	@ApiModelProperty(value = "id")
	private String id;

	@ApiModelProperty(value = "人员id")
	private String personId;

	@ApiModelProperty(value = "tab切换，1 课程 2 考试 3 练习")
	@TableField("tab_status")
	private String tabStatus;

	@ApiModelProperty(value = "计划开始时间")
	@JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@JSONField(format = "yyyy-MM-dd HH:mm:ss")
	private Date visitStartTime;

	@ApiModelProperty(value = "计划结束时间")
	@JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@JSONField(format = "yyyy-MM-dd HH:mm:ss")
	private Date visitEndTime;

	@ApiModelProperty(value = "考试成绩")
	private String testScore;

	@ApiModelProperty(value = "课程ID")
	private String courseId;

}
