/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.springboot.properties;

import com.tongweb.juli.logging.Log;
import com.tongweb.juli.logging.LogFactory;
import com.tongweb.springboot.properties.TongWebProperties;
import com.tongweb.springboot.properties.TongwebConfig;
import com.tongweb.springboot.starter.ConfigurableTongWebServerFactory;
import com.tongweb.springboot.starter.TongWebServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.core.Ordered;
import org.springframework.util.ObjectUtils;

public class TongWebServletWebServerFactoryCustomizer
implements WebServerFactoryCustomizer<TongWebServletWebServerFactory>,
Ordered {
    private static final Log logger = LogFactory.getLog(TongWebServletWebServerFactoryCustomizer.class);
    private final TongWebProperties serverProperties;

    public TongWebServletWebServerFactoryCustomizer(TongWebProperties serverProperties) {
        this.serverProperties = serverProperties;
    }

    public int getOrder() {
        return 0;
    }

    public void customize(TongWebServletWebServerFactory factory) {
        TongwebConfig tongWebProperties = this.serverProperties.getTongweb();
        if (!ObjectUtils.isEmpty(tongWebProperties.getAdditionalTldSkipPatterns())) {
            factory.getTldSkipPatterns().addAll(tongWebProperties.getAdditionalTldSkipPatterns());
        }
        if (tongWebProperties.getRedirectContextRoot() != null) {
            this.customizeRedirectContextRoot(factory, tongWebProperties.getRedirectContextRoot());
        }
        if (tongWebProperties.getUseRelativeRedirects() != null) {
            this.customizeUseRelativeRedirects(factory, tongWebProperties.getUseRelativeRedirects());
        }
        try {
            Class.forName("com.tongweb.srv.enhance.monitor.configure.MonitorProperties");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void customizeRedirectContextRoot(ConfigurableTongWebServerFactory factory, boolean redirectContextRoot) {
        factory.addContextCustomizers(context -> context.setMapperContextRootRedirectEnabled(redirectContextRoot));
    }

    private void customizeUseRelativeRedirects(ConfigurableTongWebServerFactory factory, boolean useRelativeRedirects) {
        factory.addContextCustomizers(context -> context.setUseRelativeRedirects(useRelativeRedirects));
    }
}

