package com.testor.ddd.safetyControl.interfaces.controller;

import com.testor.ddd.safetyControl.application.service.riskPointManage.RiskPointManageService;
import com.testor.ddd.safetyControl.infrastructure.uitls.RiskTemplate.DownloadRiskTemplateUtil;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskPoint.TSafeRiskPointDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskPoint.TSafeRiskPointDTOParam;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskPoint.TSafeRiskPointDelParam;
import com.testor.ddd.safetyControl.interfaces.model.vo.riskPoint.TSafeRiskPointVO;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.exception.BusinessException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.common.models.sys.UserInfo;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

/**
 * 危险源Controller
 *
 * @author testor-framework
 * @date 2022-07-11 10:00:17
 */
@RestController
@RequestMapping("/risk/point")
@Api(value = "TSafeRiskPoint", tags = "风险点")
@Slf4j
public class TSafeRiskPointController extends SuperController
{
    @Autowired
    private RiskPointManageService riskPointManageService;

	@Autowired
	private DownloadRiskTemplateUtil riskSourceTemplateUtil;

	/* Generated Method*/
	@ApiOperation(value = "新增、修改风险点", notes = "Add TSafeRiskPoint")
	@PostMapping(value = "/add")
	public BaseResponse addEntity(@RequestBody TSafeRiskPointDTO addRequest) throws BusinessException {
		return riskPointManageService.editRiskPoint(addRequest);
	}

	@ApiOperation(value = "删除 风险点 ", notes = "delete TSafeRiskPoint By Id")
	@PutMapping(value = "/delete")
	public BaseResponse deleteEntity(@RequestBody TSafeRiskPointDelParam deleteRequest) throws BusinessException {
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&& StringHelper.isNotEmpty(deleteRequest.getId())){
			baseResponse= riskPointManageService.deleteById(deleteRequest.getId());
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 风险点 分页列表", notes = "List TSafeRiskPoint with page")
	@PostMapping(value = "/list")
	public  BaseResponse<BaseResponseList<TSafeRiskPointVO>>listEntity(@RequestBody TSafeRiskPointDTOParam param){
		BaseResponse<BaseResponseList<TSafeRiskPointVO>>baseResponse=new BaseResponse<>();
		BaseResponseList<TSafeRiskPointVO> resultList= riskPointManageService.listByPage(param);
		baseResponse.setData(resultList);
		return baseResponse;
	}


	@ApiOperation(value = "获取 风险点 详情 ", notes = "Get TSafeRiskPoint By Id")
	@GetMapping(value = "/get")
	public BaseResponse<TSafeRiskPointVO> getById(String id){
		BaseResponse<TSafeRiskPointVO> baseResponse=new BaseResponse<>();
		if(StringHelper.isNotEmpty(id)){
			TSafeRiskPointVO data= riskPointManageService.findDetailById(id);
			baseResponse.setData(data);
		}
		return baseResponse;
	}

	@ApiOperation(value = "下载风险点导入模板（风险点批量导入模版_1657714259030.xlsx）")
	@GetMapping(value = "/downloadRiskPointTemplate")
	public void downloadRiskPointTemplate(HttpServletResponse response, String fileDowName) {
		UserInfo curUser = ContextUtils.getLoginUser();
		String curUserOrgId = curUser.getOrgId();
		riskSourceTemplateUtil.downloadRiskPointTemplate(response, fileDowName, curUserOrgId);
	}
}
