package com.testor.module.train.exam.model.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.testor.module.train.exam.model.domain.TTrainExamChoice;
import com.testor.module.train.exam.model.domain.TTrainTestQuestions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 管理试题——教育培训 删除参数对象
 *
 * @author testor-framework
 * @date 2022-07-13 15:22:00
 */

@Data
@ApiModel(value = "TTrainTestQuestions 列表查询参数对象")
@EqualsAndHashCode(callSuper = true)
public class TTrainTestQuestionsParam extends TTrainTestQuestions {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "每页数量")
    private String limit;

    @ApiModelProperty(value = "当前页数")
    private String page;

    @ApiModelProperty(value = "排序字段")
    private String orderBy;

    @ApiModelProperty(value = "排序方式")
    private String orderType;

    @ApiModelProperty(value = "开始时间")
    private String startDateTime;

    @ApiModelProperty(value = "结束时间")
    private String endDateTime;

    @ApiModelProperty(value = "单选题数量")
    @TableField("select_num")
    private Long selectNum;

    @ApiModelProperty(value = "多选题数量")
    @TableField("more_select_num")
    private Long moreSelectNum;

    @ApiModelProperty(value = "判断题数量")
    @TableField("judge_num")
    private Long judgeNum;

    @ApiModelProperty(value = "试题选项")
    private List<TTrainExamChoice> tTrainExamChoices;

    private String dicKey;

    private String dictValue;
}
