package com.testor.module.video.controller;

import com.testor.module.video.service.TVideoEquipmentInfoService;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.common.models.sys.UserInfo;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import com.tongtech.tfw.workflow.apis.task.TaskEnumCode;
import com.tongtech.tfw.workflow.apis.task.model.dto.CompleteTask;
import com.tongtech.tfw.workflow.service.TfwTaskService;
import com.tongtech.tfw.workflow.service.dto.TaskCompleteParams;
import com.tongtech.tfw.workflow.service.dto.TaskServiceResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;

/**
 * @title TestTaskController
 * @description <TODO description class purpose>
 * @Author: qiao
 * @version:1.0.0
 * @create：5/4/23 5:29 PM
 */
@RestController
@RequestMapping("/test001")
@Api(value = "TestTaskController", tags = "TestTaskController")
@Slf4j
public class TestTaskController extends SuperController {
    @Autowired
    private TfwTaskService tfwTaskService;

    @Autowired
    private TVideoEquipmentInfoService tVideoEquipmentInfoService;

    @ApiOperation(
            value = "完成任务",
            notes = "完成任务"
    )
    @PostMapping({"/complete"})
    public BaseResponse<BizGeneralResponse> completeTask(@RequestBody @Valid CompleteTask completeTask) {

        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse();
        if (StringHelper.isBlank(completeTask.getUserId())) {
            completeTask.setUserId(this.getUserId());
        }
        if (StringHelper.isBlank(completeTask.getOrgId())) {
            UserInfo curUser = ContextUtils.getLoginUser();
            completeTask.setOrgId(curUser.getOrgId());
        }

        if (StringHelper.isBlank(completeTask.getBizId())) {
            completeTask.setBizId(IdHelper.getId32bitTime());
        }
        tVideoEquipmentInfoService.completeTask(completeTask);
        try {
            TaskCompleteParams taskCompleteParams = (TaskCompleteParams) BeanHelper.beanToBean(completeTask, TaskCompleteParams.class);
            TaskServiceResult taskServiceResult = this.tfwTaskService.completeTask(taskCompleteParams);
            baseResponse.setData(BizGeneralResponse.builder().result(taskServiceResult.getCode()).build());
            return baseResponse;
        } catch (Exception var5) {
//            log.error("完成任务 ERROR: " + var5);
            var5.printStackTrace();
            throw new ApiException(TaskEnumCode.COMPLETE_FAILED.transform());
        }
    }
}
