/*
 * Decompiled with CFR 0.152.
 */
package com.testor.biz.sys.file.util;

import com.testor.biz.file.model.domain.SysFile;
import com.testor.biz.file.model.dto.FileDTO;
import com.testor.biz.file.service.SysFileService;
import com.testor.biz.sys.file.config.ObjectItem;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.exception.BusinessException;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import io.minio.BucketExistsArgs;
import io.minio.GetObjectArgs;
import io.minio.ListObjectsArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveBucketArgs;
import io.minio.RemoveObjectsArgs;
import io.minio.Result;
import io.minio.SetBucketPolicyArgs;
import io.minio.StatObjectArgs;
import io.minio.messages.DeleteError;
import io.minio.messages.DeleteObject;
import io.minio.messages.Item;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;

@Component
public class MinioUtilS {
    @Autowired
    private SysFileService sysFileService;
    @Autowired
    private MinioClient minioClient;
    @Value(value="${minio.bucket}")
    private String bucketName;
    @Value(value="${minio.endpoint}")
    private String address;
    @Value(value="${apisix.minioroute.url}")
    private String apisixUrl;

    public void existBucket(String name) {
        try {
            boolean exists = this.minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(name)).build());
            if (!exists) {
                this.minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(name)).build());
                String config = "{\n\t\"Version\": \"2012-10-17\",\n\t\"Statement\": [{\n\t\t\"Effect\": \"Allow\",\n\t\t\"Principal\": {\n\t\t\t\"AWS\": [\"*\"]\n\t\t},\n\t\t\"Action\": [\"s3:GetBucketLocation\", \"s3:ListBucket\", \"s3:ListBucketMultipartUploads\"],\n\t\t\"Resource\": [\"arn:aws:s3:::zlmy\"]\n\t}, {\n\t\t\"Effect\": \"Allow\",\n\t\t\"Principal\": {\n\t\t\t\"AWS\": [\"*\"]\n\t\t},\n\t\t\"Action\": [\"s3:AbortMultipartUpload\", \"s3:DeleteObject\", \"s3:GetObject\", \"s3:ListMultipartUploadParts\", \"s3:PutObject\"],\n\t\t\"Resource\": [\"arn:aws:s3:::zlmy/*\"]\n\t}]\n}";
                this.minioClient.setBucketPolicy((SetBucketPolicyArgs)((SetBucketPolicyArgs.Builder)SetBucketPolicyArgs.builder().bucket(this.bucketName)).config(config).build());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Boolean makeBucket(String bucketName) {
        try {
            this.minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketName)).build());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public Boolean removeBucket(String bucketName) {
        try {
            this.minioClient.removeBucket((RemoveBucketArgs)((RemoveBucketArgs.Builder)RemoveBucketArgs.builder().bucket(bucketName)).build());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public List<FileDTO> upload(MultipartFile[] multipartFile) throws Exception {
        ArrayList<FileDTO> names = new ArrayList<FileDTO>(multipartFile.length);
        for (MultipartFile file : multipartFile) {
            SysFile sysFile = new SysFile();
            FileDTO fileDTO = new FileDTO();
            String fileName = file.getOriginalFilename();
            sysFile.setFileName(fileName);
            fileDTO.setFileName(fileName);
            String fileId = IdHelper.getId32bitTime();
            double size = file.getSize();
            int beginIndex = fileName.lastIndexOf(".");
            String ext = StringHelper.substring((String)fileName, (int)beginIndex, (int)fileName.length());
            fileName = fileName.replaceAll(" ", "");
            fileName = fileName.replaceAll("-", "");
            fileName = fileName.replaceAll("_", "");
            String[] split = fileName.split("\\.");
            fileName = split.length > 1 ? split[0] + "_" + System.currentTimeMillis() + ext : fileName + System.currentTimeMillis();
            InputStream in = null;
            try {
                this.existBucket(this.bucketName);
                in = file.getInputStream();
                this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.bucketName)).object(fileName)).stream(in, (long)in.available(), -1L).contentType(file.getContentType()).build());
                String loginName = ContextUtils.getLoginUser().getUserId();
                if (loginName == null) continue;
                sysFile.setCreateBy(loginName);
                sysFile.setUpdateBy(loginName);
                sysFile.setFileId(fileId);
                sysFile.setFileExt(ext);
                sysFile.setFileDowName(fileName);
                sysFile.setFileSize(BigDecimal.valueOf(size));
                String filePath = "";
                if (this.apisixUrl != null && this.apisixUrl != "") {
                    filePath = this.apisixUrl + "/" + this.bucketName + "/" + fileName;
                    sysFile.setFilePath(filePath);
                } else {
                    filePath = this.address + "/" + this.bucketName + "/" + fileName;
                    sysFile.setFilePath(filePath);
                }
                this.sysFileService.save((Object)sysFile);
                fileDTO.setFileId(fileId);
                fileDTO.setFilePath(filePath);
                fileDTO.setFileDowName(fileName);
                names.add(fileDTO);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BusinessException("\u4e0a\u4f20\u5931\u8d25");
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseEntity<byte[]> download(String fileName) {
        ResponseEntity responseEntity = null;
        InputStream in = null;
        ByteArrayOutputStream out = null;
        try {
            in = this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(this.bucketName)).object(fileName)).build());
            out = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)in, (OutputStream)out);
            byte[] bytes = out.toByteArray();
            HttpHeaders headers = new HttpHeaders();
            try {
                headers.add("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            headers.setContentLength((long)bytes.length);
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setAccessControlExposeHeaders(Arrays.asList("*"));
            responseEntity = new ResponseEntity((Object)bytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return responseEntity;
    }

    public InputStream downloadForIn(String fileName) {
        try {
            return this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(this.bucketName)).object(fileName)).build());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<ObjectItem> listObjects(String bucketName) {
        Iterable results = this.minioClient.listObjects((ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(bucketName)).build());
        ArrayList<ObjectItem> objectItems = new ArrayList<ObjectItem>();
        try {
            for (Result result : results) {
                Item item = (Item)result.get();
                ObjectItem objectItem = new ObjectItem();
                objectItem.setObjectName(item.objectName());
                objectItem.setSize(item.size());
                objectItems.add(objectItem);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return objectItems;
    }

    public Iterable<Result<DeleteError>> removeObjects(String bucketName, List<String> objects) {
        List dos = objects.stream().map(e -> new DeleteObject(e)).collect(Collectors.toList());
        Iterable results = this.minioClient.removeObjects((RemoveObjectsArgs)((RemoveObjectsArgs.Builder)RemoveObjectsArgs.builder().bucket(bucketName)).objects(dos).build());
        return results;
    }

    public boolean isObjectExist(String fileName) {
        boolean exist = true;
        try {
            this.minioClient.statObject((StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(this.bucketName)).object(fileName)).build());
        }
        catch (Exception e) {
            exist = false;
        }
        return exist;
    }
}

