package com.testor.common.excel.select.impl;

import com.testor.common.annotation.ExcelSelectedType;
import com.testor.common.constant.ExcelSelectConstant;
import com.testor.common.excel.select.ExcelDynamicSelect;
import com.testor.module.sys.model.domian.NewSysOrg;
import com.testor.module.sys.service.NewSysOrgService;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import lombok.AllArgsConstructor;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;


@Component
@AllArgsConstructor
@ExcelSelectedType(type = ExcelSelectConstant.DEPT_DATA_BY_ID)
public class DeptSelectImpl implements ExcelDynamicSelect<String> {

    @Autowired
    private NewSysOrgService newSysOrgService;

    @Override
    public List<String> getSource(Object param) {
        String orgId = param.toString();
        if (StringUtils.isBlank(orgId)) {
            // 获取当前登录用户的组织ID
            orgId = ContextUtils.getLoginUser().getOrgId();
        }
        // 获取当前组织ID下的所有子部门
        List<NewSysOrg> childrenDept = newSysOrgService.getChildrenDept(orgId);
        // 将子部门列表中的组织名称提取出来，并转换为字符串列表
        List<String> collect = childrenDept.stream().map(NewSysOrg::getOrgName).collect(Collectors.toList());
        // 将字符串列表转换为字符串数组并返回
        return collect;
    }
}
