package com.testor.module.contractor.manage.model.dto;

import com.testor.module.contractor.manage.model.domain.TContractorConditionReviewDetail;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.List;
import java.util.Map;

import com.testor.module.contractor.manage.model.domain.TContractorConditionReview;

/**
 * 承包商管理-条件审查 删除参数对象
 *
 * @author testor-framework
 * @date 2024-11-26 10:39:58
 */

@Data
@ApiModel(value = "TContractorConditionReview 列表查询参数对象")
@EqualsAndHashCode(callSuper = true)
public class TContractorConditionReviewParam extends TContractorConditionReview {
	private static final long serialVersionUID = 1L;
	@ApiModelProperty(value = "每页数量")
	private String limit;

	@ApiModelProperty(value = "当前页数")
	private String page;

	@ApiModelProperty(value = "排序字段")
	private String orderBy;

	@ApiModelProperty(value = "排序方式")
	private String orderType;

	@ApiModelProperty(value = "待办任务id")
	private String taskId;

	@ApiModelProperty(value = "承包商名称")
	private String contractorName;

	/**
	 * 项目名称
	 */
	@ApiModelProperty(value = "项目名称")
	private String projectName;

	/**
	 * 施工地点
	 */
	@ApiModelProperty(value = "施工地点")
	private String constructionLocation;

	@ApiModelProperty(value = "审查内容明细")
	private List<TContractorConditionReviewDetail> reviewDetails;

	@ApiModelProperty(value = "审批参数")
	private Map<String, Object> vars;

}
