package com.testor.module.contractor.manage.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.contractor.manage.model.domain.TContractorBasicInfo;
import com.testor.module.contractor.manage.model.dto.ContractorInfoDTO;
import com.testor.module.contractor.manage.model.dto.TContractorBasicInfoParam;
import com.tongtech.tfw.backend.common.exception.BusinessException;
import com.tongtech.tfw.backend.common.models.supers.SuperService;

/**
 * 基本管理Service接口
 * 
 * @author testor-framework
 * @date 2024-11-22 21:03:04
 */
public interface TContractorBasicInfoService extends SuperService<TContractorBasicInfo> {

    /**
     * 分页查询基本管理
     *
     * @param param 分页参数
     * @return 基本管理
     */
    Page<ContractorInfoDTO> pageList(TContractorBasicInfoParam param);

    /**
     * 新增基本管理
     * @param addRequest
     * @return
     */
    TContractorBasicInfo addEntity(TContractorBasicInfoParam addRequest);

    /**
     * 修改基本信息
     * @param data
     * @return
     */
    TContractorBasicInfo updateEntity(TContractorBasicInfoParam data);

    void submit(TContractorBasicInfoParam updateRequest);

    void completeProcess(TContractorBasicInfoParam updateRequest);

    /**
     * 驳回基本管理
     * @param bizId
     * @param rollbackReason
     * @param operator
     */
    void rollbackToPending(String bizId) throws BusinessException;
}
