package com.testor.module.hazard.dao;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.hazard.model.domain.THazardWorkPlan;
import com.testor.module.hazard.model.dto.THazardWorkPlanParam;
import com.testor.module.hazard.model.dto.THazardWorkPlanRiverside;
import com.tongtech.tfw.backend.common.models.supers.SuperDao;
import com.tongtech.tfw.workflow.apis.task.model.dto.TodoTask;
import com.tongtech.tfw.workflow.apis.task.model.dto.TodoTaskSqlParam;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

import java.util.List;

/**
 * 危险作业计划Mapper接口
 *
 * @author testor-framework
 * @date 2024-12-19 10:39:26
 */
public interface THazardWorkPlanDao extends SuperDao<THazardWorkPlan>
{
    IPage<TodoTask> selectToDoList(Page<TodoTask> resultPage,@Param("todo") TodoTaskSqlParam todoTaskSqlParam);

    @Update("UPDATE t_hazard_work_plan SET actual_start_time = NOW() WHERE id = #{id}")
    void updateActualStartTime(@Param("id") String id);

    @Update("UPDATE t_hazard_work_plan SET work_status = 1 WHERE code = #{code}")
    void updateWorkStatus(@Param("code") String code);

    @Select("SELECT * FROM t_hazard_work_plan WHERE code = #{code} and status = 0")
    THazardWorkPlan selectByCode(@Param("code") String code);


    /**
     * 查询所有危险作业已安全许可申请审批通过后未完成的作业
     * @return
     */
    List<THazardWorkPlan> selectHazardLicensePassTime();

    /**
     * 对外沿江大区提供危险作业数据
     * @return
     */
    Page<THazardWorkPlanRiverside> riversideList(Page<THazardWorkPlan> page,@Param("param") THazardWorkPlanParam param);

}
